/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.asynchttpclient;

import co.elastic.apm.agent.bci.ElasticApmAgent;
import co.elastic.apm.agent.bci.ElasticApmInstrumentation;
import co.elastic.apm.agent.bci.HelperClassManager;
import co.elastic.apm.agent.bci.bytebuddy.CustomElementMatchers;
import co.elastic.apm.agent.http.client.HttpClientHelper;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.TextHeaderSetter;
import co.elastic.apm.agent.impl.transaction.TraceContextHolder;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import co.elastic.apm.agent.shaded.weaklockfree.WeakConcurrentMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.HttpResponseStatus;
import org.asynchttpclient.Request;
import org.asynchttpclient.uri.Uri;

public abstract class AbstractAsyncHttpClientInstrumentation
extends ElasticApmInstrumentation {
    @Nullable
    public static HelperClassManager<TextHeaderSetter<Request>> headerSetterManager;
    public static final WeakConcurrentMap<AsyncHandler<?>, Span> handlerSpanMap;
    public static final List<Class<? extends ElasticApmInstrumentation>> ASYNC_HANDLER_INSTRUMENTATIONS;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AbstractAsyncHttpClientInstrumentation() {
        if (headerSetterManager != null) return;
        Class<AbstractAsyncHandlerInstrumentation> clazz = AbstractAsyncHandlerInstrumentation.class;
        synchronized (AbstractAsyncHandlerInstrumentation.class) {
            if (headerSetterManager != null) return;
            headerSetterManager = HelperClassManager.ForAnyClassLoader.of(tracer, "co.elastic.apm.agent.asynchttpclient.helper.RequestHeaderSetter", new String[0]);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Arrays.asList("http-client", "asynchttpclient");
    }

    @Override
    public ElementMatcher.Junction<ClassLoader> getClassLoaderMatcher() {
        return ElementMatchers.not(ElementMatchers.isBootstrapClassLoader()).and(CustomElementMatchers.classLoaderCanLoadClass("org.asynchttpclient.AsyncHandler"));
    }

    static {
        handlerSpanMap = new WeakConcurrentMap.WithInlinedExpunction();
        ASYNC_HANDLER_INSTRUMENTATIONS = Arrays.asList(AsyncHandlerOnCompletedInstrumentation.class, AsyncHandlerOnThrowableInstrumentation.class, AsyncHandlerOnStatusReceivedInstrumentation.class);
    }

    public static class AsyncHandlerOnStatusReceivedInstrumentation
    extends AbstractAsyncHandlerInstrumentation {
        public AsyncHandlerOnStatusReceivedInstrumentation() {
            super(ElementMatchers.named("onStatusReceived").and(ElementMatchers.takesArgument(0, ElementMatchers.named("org.asynchttpclient.HttpResponseStatus"))));
        }

        @Advice.OnMethodEnter(suppress=Throwable.class)
        private static void onMethodEnter(@Advice.This AsyncHandler<?> asyncHandler, @Advice.Argument(value=0) HttpResponseStatus status) {
            Span span = (Span)handlerSpanMap.get(asyncHandler);
            if (span != null) {
                span.getContext().getHttp().withStatusCode(status.getStatusCode());
            }
        }
    }

    public static class AsyncHandlerOnThrowableInstrumentation
    extends AbstractAsyncHandlerInstrumentation {
        public AsyncHandlerOnThrowableInstrumentation() {
            super(ElementMatchers.named("onThrowable").and(ElementMatchers.takesArguments(Throwable.class)));
        }

        @Advice.OnMethodEnter(suppress=Throwable.class)
        private static void onMethodEnter(@Advice.This AsyncHandler<?> asyncHandler, @Advice.Argument(value=0) Throwable t) {
            Span span = (Span)handlerSpanMap.remove(asyncHandler);
            if (span != null) {
                ((Span)span.captureException(t)).end();
            }
        }
    }

    public static class AsyncHandlerOnCompletedInstrumentation
    extends AbstractAsyncHandlerInstrumentation {
        public AsyncHandlerOnCompletedInstrumentation() {
            super(ElementMatchers.named("onCompleted").and(ElementMatchers.takesArguments(0)));
        }

        @Advice.OnMethodEnter(suppress=Throwable.class)
        private static void onMethodEnter(@Advice.This AsyncHandler<?> asyncHandler) {
            Span span = (Span)handlerSpanMap.remove(asyncHandler);
            if (span != null) {
                span.end();
            }
        }
    }

    public static abstract class AbstractAsyncHandlerInstrumentation
    extends AbstractAsyncHttpClientInstrumentation {
        private final ElementMatcher<? super MethodDescription> methodMatcher;

        protected AbstractAsyncHandlerInstrumentation(ElementMatcher<? super MethodDescription> methodMatcher) {
            this.methodMatcher = methodMatcher;
        }

        @Override
        public ElementMatcher<? super TypeDescription> getTypeMatcher() {
            return ElementMatchers.any();
        }

        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return this.methodMatcher;
        }
    }

    public static class AsyncHttpClientInstrumentation
    extends AbstractAsyncHttpClientInstrumentation {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        private static void onBeforeExecute(@Advice.Argument(value=0) Request request, @Advice.Argument(value=1) AsyncHandler<?> asyncHandler, @Advice.Local(value="span") Span span) {
            if (tracer == null || tracer.getActive() == null) {
                return;
            }
            ElasticApmAgent.ensureInstrumented(asyncHandler.getClass(), ASYNC_HANDLER_INSTRUMENTATIONS);
            TraceContextHolder<?> parent = tracer.getActive();
            Uri uri = request.getUri();
            span = HttpClientHelper.startHttpClientSpan(parent, request.getMethod(), uri.toUrl(), uri.getScheme(), uri.getHost(), uri.getPort());
            if (span != null) {
                span.activate();
                TextHeaderSetter headerSetter = null;
                if (headerSetterManager != null) {
                    headerSetter = (TextHeaderSetter)headerSetterManager.getForClassLoaderOfClass(Request.class);
                }
                if (headerSetter != null) {
                    span.getTraceContext().setOutgoingTraceContextHeaders(request, headerSetter);
                }
                handlerSpanMap.put(asyncHandler, span);
            }
        }

        @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class)
        private static void onAfterExecute(@Advice.Local(value="span") @Nullable Span span, @Advice.Argument(value=1) AsyncHandler<?> asyncHandler, @Advice.Thrown @Nullable Throwable t) {
            if (span != null) {
                span.deactivate();
                if (t != null) {
                    handlerSpanMap.remove(asyncHandler);
                    ((Span)span.captureException(t)).end();
                }
            }
        }

        @Override
        public ElementMatcher<? super TypeDescription> getTypeMatcher() {
            return ElementMatchers.named("org.asynchttpclient.DefaultAsyncHttpClient");
        }

        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("executeRequest").and(ElementMatchers.takesArgument(0, ElementMatchers.named("org.asynchttpclient.Request"))).and(ElementMatchers.takesArgument(1, ElementMatchers.named("org.asynchttpclient.AsyncHandler")));
        }
    }
}

