/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.bci;

import java.io.File;
import java.lang.instrument.Instrumentation;
import java.net.URISyntaxException;
import java.nio.file.FileSystems;
import java.util.jar.JarFile;

public class AgentMain {
    public static void premain(String agentArguments, Instrumentation instrumentation) {
        AgentMain.init(agentArguments, instrumentation, true);
    }

    public static void agentmain(String agentArguments, Instrumentation instrumentation) {
        AgentMain.init(agentArguments, instrumentation, false);
    }

    public static synchronized void init(String agentArguments, Instrumentation instrumentation, boolean premain) {
        String javaVmName;
        if (Boolean.getBoolean("ElasticApm.attached")) {
            return;
        }
        String javaVersion = System.getProperty("java.version");
        if (!AgentMain.isJavaVersionSupported(javaVersion, javaVmName = System.getProperty("java.vm.name"))) {
            System.err.println(String.format("Failed to start agent - JVM version not supported: %s", javaVersion));
            return;
        }
        try {
            FileSystems.getDefault();
            File agentJarFile = AgentMain.getAgentJarFile();
            try (JarFile jarFile = new JarFile(agentJarFile);){
                instrumentation.appendToBootstrapClassLoaderSearch(jarFile);
            }
            Class.forName("co.elastic.apm.agent.bci.ElasticApmAgent", true, null).getMethod("initialize", String.class, Instrumentation.class, File.class, Boolean.TYPE).invoke(null, agentArguments, instrumentation, agentJarFile, premain);
            System.setProperty("ElasticApm.attached", Boolean.TRUE.toString());
        }
        catch (Exception e) {
            System.err.println("Failed to start agent");
            e.printStackTrace();
        }
    }

    static boolean isJavaVersionSupported(String version, String vmName) {
        boolean postJsr223;
        boolean bl = postJsr223 = !version.startsWith("1.");
        if (postJsr223) {
            return true;
        }
        char major = version.charAt(2);
        if (major < '7') {
            return false;
        }
        if (major == '7' || major > '8') {
            return true;
        }
        if (!vmName.contains("HotSpot(TM)")) {
            return true;
        }
        int updateIndex = version.lastIndexOf("_");
        if (updateIndex <= 0) {
            return false;
        }
        int versionSuffixIndex = version.indexOf(45, updateIndex + 1);
        String updateVersion = versionSuffixIndex <= 0 ? version.substring(updateIndex + 1) : version.substring(updateIndex + 1, versionSuffixIndex);
        try {
            return Integer.parseInt(updateVersion) >= 40;
        }
        catch (NumberFormatException e) {
            return true;
        }
    }

    private static File getAgentJarFile() throws URISyntaxException {
        File agentJar = new File(AgentMain.class.getProtectionDomain().getCodeSource().getLocation().toURI());
        if (!agentJar.getName().endsWith(".jar")) {
            throw new IllegalStateException("Agent is not a jar file: " + agentJar);
        }
        return agentJar.getAbsoluteFile();
    }
}

