/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.bci;

import co.elastic.apm.agent.configuration.CoreConfiguration;
import co.elastic.apm.agent.context.AbstractLifecycleListener;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import javax.annotation.Nullable;

public class OsgiBootDelegationEnabler
extends AbstractLifecycleListener {
    private static final String APM_BASE_PACKAGE = "co.elastic.apm.agent.*";
    private static final String ATLASSIAN_BOOTDELEGATION_DEFAULTS = "META-INF.services,com.yourkit,com.singularity.*,com.jprofiler,com.jprofiler.*,org.apache.xerces,org.apache.xerces.*,org.apache.xalan,org.apache.xalan.*,sun.*,com.sun.jndi.*,com.icl.saxon,com.icl.saxon.*,javax.servlet,javax.servlet.*,com.sun.xml.bind.*";

    @Override
    public void start(ElasticApmTracer tracer) {
        String packagesToAppendToBootdelegationProperty = tracer.getConfig(CoreConfiguration.class).getPackagesToAppendToBootdelegationProperty();
        if (packagesToAppendToBootdelegationProperty != null) {
            OsgiBootDelegationEnabler.appendToSystemProperty("org.osgi.framework.bootdelegation", packagesToAppendToBootdelegationProperty);
        }
        OsgiBootDelegationEnabler.appendToSystemProperty("atlassian.org.osgi.framework.bootdelegation", ATLASSIAN_BOOTDELEGATION_DEFAULTS, APM_BASE_PACKAGE);
    }

    private static void appendToSystemProperty(String propertyName, String append) {
        OsgiBootDelegationEnabler.appendToSystemProperty(propertyName, null, append);
    }

    private static void appendToSystemProperty(String propertyName, @Nullable String propertyValueDefault, String append) {
        String systemPackages = System.getProperty(propertyName, propertyValueDefault);
        if (systemPackages != null) {
            System.setProperty(propertyName, systemPackages + "," + append);
        } else {
            System.setProperty(propertyName, append);
        }
    }
}

