/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.bci.bytebuddy;

import co.elastic.apm.agent.bci.bytebuddy.MinimumClassFileVersionValidator;
import co.elastic.apm.agent.shaded.bytebuddy.agent.builder.AgentBuilder;
import co.elastic.apm.agent.shaded.bytebuddy.utility.JavaModule;
import co.elastic.apm.agent.shaded.slf4j.Logger;
import co.elastic.apm.agent.shaded.slf4j.LoggerFactory;

public class ErrorLoggingListener
extends AgentBuilder.Listener.Adapter {
    private static final Logger logger = LoggerFactory.getLogger(ErrorLoggingListener.class);

    @Override
    public void onError(String typeName, ClassLoader classLoader, JavaModule module, boolean loaded, Throwable throwable) {
        if (throwable instanceof MinimumClassFileVersionValidator.UnsupportedClassFileVersionException) {
            logger.warn("{} uses an unsupported class file version (pre Java 5) and can't be instrumented. Consider updating to a newer version of that library.", (Object)typeName);
        } else if (throwable.getMessage().contains("Cannot resolve type description")) {
            logger.info(typeName + " refers to a missing class", throwable);
        } else {
            logger.warn("Error on transformation " + typeName, throwable);
        }
    }
}

