/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.bci.methodmatching;

import co.elastic.apm.agent.matcher.AnnotationMatcher;
import co.elastic.apm.agent.matcher.WildcardMatcher;
import co.elastic.apm.agent.shaded.stagemonitor.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class MethodMatcher {
    private static final String MODIFIER = "(?<modifier>public|private|protected|\\*)";
    private static final String ANNOTATION = "((?<annotation>@@?[a-zA-Z\\d_$.\\*]+)\\s+)?";
    private static final String CLASS_NAME = "(?<clazz>[a-zA-Z\\d_$.\\*]+)";
    private static final String METHOD_NAME = "(?<method>[a-zA-Z\\d_$\\*]+)";
    private static final String PARAM = "([a-zA-Z\\d_$.\\[\\]\\*]+)";
    private static final String PARAMS = "([a-zA-Z\\d_$.\\[\\]\\*]+)(,\\s*([a-zA-Z\\d_$.\\[\\]\\*]+))*";
    private static final Pattern METHOD_MATCHER_PATTERN = Pattern.compile("^((?<modifier>public|private|protected|\\*)\\s+)?((?<annotation>@@?[a-zA-Z\\d_$.\\*]+)\\s+)?(?<clazz>[a-zA-Z\\d_$.\\*]+)(#(?<method>[a-zA-Z\\d_$\\*]+)(?<params>\\((([a-zA-Z\\d_$.\\[\\]\\*]+)(,\\s*([a-zA-Z\\d_$.\\[\\]\\*]+))*)*\\))?)?$");
    private final String stringRepresentation;
    @Nullable
    private final Integer modifier;
    private final AnnotationMatcher annotationMatcher;
    private final WildcardMatcher classMatcher;
    private final WildcardMatcher methodMatcher;
    @Nullable
    private final List<WildcardMatcher> argumentMatchers;

    private MethodMatcher(String stringRepresentation, @Nullable Integer modifier, AnnotationMatcher annotationMatcher, WildcardMatcher classMatcher, WildcardMatcher methodMatcher, @Nullable List<WildcardMatcher> argumentMatchers) {
        this.stringRepresentation = stringRepresentation;
        this.modifier = modifier;
        this.annotationMatcher = annotationMatcher;
        this.classMatcher = classMatcher;
        this.methodMatcher = methodMatcher;
        this.argumentMatchers = argumentMatchers;
    }

    public static MethodMatcher of(String methodMatcher) {
        Matcher matcher = METHOD_MATCHER_PATTERN.matcher(methodMatcher);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("'" + methodMatcher + "' is not a valid method matcher");
        }
        String modifier = matcher.group("modifier");
        AnnotationMatcher annotationMatcher = matcher.group("annotation") != null ? AnnotationMatcher.annotationMatcher(matcher.group("annotation")) : AnnotationMatcher.matchAll();
        WildcardMatcher clazz = WildcardMatcher.caseSensitiveMatcher(matcher.group("clazz"));
        WildcardMatcher method = matcher.group("method") != null ? WildcardMatcher.caseSensitiveMatcher(matcher.group("method")) : WildcardMatcher.matchAll();
        List<WildcardMatcher> args = MethodMatcher.getArgumentMatchers(matcher.group("params"));
        return new MethodMatcher(methodMatcher, MethodMatcher.getModifier(modifier), annotationMatcher, clazz, method, args);
    }

    @Nullable
    private static Integer getModifier(@Nullable String modifier) {
        if (modifier == null) {
            return null;
        }
        switch (modifier) {
            case "public": {
                return 1;
            }
            case "private": {
                return 2;
            }
            case "protected": {
                return 4;
            }
        }
        return null;
    }

    @Nullable
    private static List<WildcardMatcher> getArgumentMatchers(@Nullable String arguments) {
        if (arguments == null) {
            return null;
        }
        arguments = arguments.substring(1, arguments.length() - 1);
        String[] splitArguments = StringUtils.split(arguments, ',');
        ArrayList<WildcardMatcher> matchers = new ArrayList<WildcardMatcher>(splitArguments.length);
        for (String argument : splitArguments) {
            matchers.add(WildcardMatcher.caseSensitiveMatcher(argument.trim()));
        }
        return matchers;
    }

    public AnnotationMatcher getAnnotationMatcher() {
        return this.annotationMatcher;
    }

    public WildcardMatcher getClassMatcher() {
        return this.classMatcher;
    }

    @Nullable
    public Integer getModifier() {
        return this.modifier;
    }

    public WildcardMatcher getMethodMatcher() {
        return this.methodMatcher;
    }

    @Nullable
    public List<WildcardMatcher> getArgumentMatchers() {
        return this.argumentMatchers;
    }

    public String toString() {
        return this.stringRepresentation;
    }
}

