/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.bci.methodmatching;

import co.elastic.apm.agent.bci.ElasticApmInstrumentation;
import co.elastic.apm.agent.bci.bytebuddy.CustomElementMatchers;
import co.elastic.apm.agent.bci.bytebuddy.SimpleMethodSignatureOffsetMappingFactory;
import co.elastic.apm.agent.bci.methodmatching.MethodMatcher;
import co.elastic.apm.agent.configuration.CoreConfiguration;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.TraceContextHolder;
import co.elastic.apm.agent.matcher.WildcardMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.NamedElement;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

public class TraceMethodInstrumentation
extends ElasticApmInstrumentation {
    public static long traceMethodThresholdMicros;
    protected final MethodMatcher methodMatcher;

    public TraceMethodInstrumentation(ElasticApmTracer tracer, MethodMatcher methodMatcher) {
        this.methodMatcher = methodMatcher;
        traceMethodThresholdMicros = tracer.getConfig(CoreConfiguration.class).getTraceMethodsDurationThreshold().getMillis() * 1000L;
    }

    @Advice.OnMethodEnter(suppress=Throwable.class)
    public static void onMethodEnter(@Advice.Origin Class<?> clazz, @SimpleMethodSignatureOffsetMappingFactory.SimpleMethodSignature String signature, @Advice.Local(value="span") AbstractSpan<?> span) {
        if (tracer != null) {
            TraceContextHolder<?> parent = tracer.getActive();
            if (parent == null) {
                span = tracer.startRootTransaction(clazz.getClassLoader());
                if (span != null) {
                    ((AbstractSpan)((AbstractSpan)span).withName(signature)).activate();
                }
            } else if (parent.isSampled()) {
                span = ((Span)parent.createSpan().withName(signature)).activate();
                span.setDiscard(true);
            }
        }
    }

    @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class)
    public static void onMethodExit(@Advice.Local(value="span") @Nullable AbstractSpan<?> span, @Advice.Thrown @Nullable Throwable t) {
        if (span != null) {
            span.captureException(t);
            long endTime = span.getTraceContext().getClock().getEpochMicros();
            if (span instanceof Span) {
                long durationMicros = endTime - span.getTimestamp();
                if (traceMethodThresholdMicros <= 0L || durationMicros >= traceMethodThresholdMicros || t != null) {
                    span.setDiscard(false);
                }
            }
            ((AbstractSpan)span.deactivate()).end(endTime);
        }
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return CustomElementMatchers.matches(this.methodMatcher.getClassMatcher()).and(this.methodMatcher.getAnnotationMatcher()).and(ElementMatchers.not(ElementMatchers.nameContains("$JaxbAccessor"))).and(ElementMatchers.not(ElementMatchers.nameContains("$$"))).and(ElementMatchers.not(ElementMatchers.nameContains("CGLIB"))).and(ElementMatchers.not(ElementMatchers.nameContains("EnhancerBy"))).and(ElementMatchers.not(ElementMatchers.nameContains("$Proxy"))).and(ElementMatchers.declaresMethod(CustomElementMatchers.matches(this.methodMatcher.getMethodMatcher())));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        List<WildcardMatcher> methodsExcludedFromInstrumentation;
        ElementMatcher.Junction<NamedElement> matcher = CustomElementMatchers.matches(this.methodMatcher.getMethodMatcher());
        List<WildcardMatcher> list = methodsExcludedFromInstrumentation = tracer != null ? tracer.getConfig(CoreConfiguration.class).getMethodsExcludedFromInstrumentation() : null;
        if (methodsExcludedFromInstrumentation != null && !methodsExcludedFromInstrumentation.isEmpty()) {
            matcher = matcher.and(ElementMatchers.not(new ElementMatcher<MethodDescription>(){

                @Override
                public boolean matches(MethodDescription target) {
                    return WildcardMatcher.anyMatch(methodsExcludedFromInstrumentation, target.getActualName()) != null;
                }
            }));
        }
        if (this.methodMatcher.getModifier() != null) {
            switch (this.methodMatcher.getModifier()) {
                case 1: {
                    matcher = matcher.and(ElementMatchers.isPublic());
                    break;
                }
                case 4: {
                    matcher = matcher.and(ElementMatchers.isProtected());
                    break;
                }
                case 2: {
                    matcher = matcher.and(ElementMatchers.isPrivate());
                }
            }
        }
        if (this.methodMatcher.getArgumentMatchers() != null) {
            matcher = matcher.and(ElementMatchers.takesArguments(this.methodMatcher.getArgumentMatchers().size()));
            List<WildcardMatcher> argumentMatchers = this.methodMatcher.getArgumentMatchers();
            for (int i = 0; i < argumentMatchers.size(); ++i) {
                matcher = matcher.and(ElementMatchers.takesArgument(i, CustomElementMatchers.matches(argumentMatchers.get(i))));
            }
        }
        return matcher.and(ElementMatchers.not(ElementMatchers.isConstructor())).and(ElementMatchers.not(ElementMatchers.isAbstract())).and(ElementMatchers.not(ElementMatchers.isNative())).and(ElementMatchers.not(ElementMatchers.isSynthetic())).and(ElementMatchers.not(ElementMatchers.isTypeInitializer()));
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Collections.singletonList("method-matching");
    }
}

