/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.es.restclient;

import co.elastic.apm.agent.es.restclient.ElasticsearchRestClientInstrumentationHelperImpl;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.objectpool.Recyclable;
import javax.annotation.Nullable;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseListener;

public class ResponseListenerWrapper
implements ResponseListener,
Recyclable {
    private ElasticsearchRestClientInstrumentationHelperImpl helper;
    @Nullable
    private ResponseListener delegate;
    @Nullable
    private volatile Span span;

    ResponseListenerWrapper(ElasticsearchRestClientInstrumentationHelperImpl helper) {
        this.helper = helper;
    }

    ResponseListenerWrapper with(ResponseListener delegate, Span span) {
        this.delegate = delegate;
        this.span = span;
        return this;
    }

    public void onSuccess(Response response) {
        try {
            this.finishClientSpan(response, null);
        }
        finally {
            if (this.delegate != null) {
                this.delegate.onSuccess(response);
            }
            this.helper.recycle(this);
        }
    }

    public void onFailure(Exception exception) {
        try {
            this.finishClientSpan(null, exception);
        }
        finally {
            if (this.delegate != null) {
                this.delegate.onFailure(exception);
            }
            this.helper.recycle(this);
        }
    }

    private void finishClientSpan(@Nullable Response response, @Nullable Throwable throwable) {
        Span localSpan = this.span;
        if (localSpan != null) {
            this.helper.finishClientSpan(response, localSpan, throwable);
        }
    }

    @Override
    public void resetState() {
        this.delegate = null;
        this.span = null;
    }
}

