/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.es.restclient.v6_4;

import co.elastic.apm.agent.es.restclient.ElasticsearchRestClientInstrumentation;
import co.elastic.apm.agent.es.restclient.ElasticsearchRestClientInstrumentationHelper;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import javax.annotation.Nullable;
import org.apache.http.HttpEntity;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseListener;

public class ElasticsearchClientSyncInstrumentation
extends ElasticsearchRestClientInstrumentation {
    public ElasticsearchClientSyncInstrumentation(ElasticApmTracer tracer) {
        super(tracer);
    }

    @Override
    public Class<?> getAdviceClass() {
        return ElasticsearchRestClientSyncAdvice.class;
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("org.elasticsearch.client.RestClient");
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("performRequest").and(ElementMatchers.takesArguments(1).and(ElementMatchers.takesArgument(0, ElementMatchers.named("org.elasticsearch.client.Request"))));
    }

    private static class ElasticsearchRestClientSyncAdvice {
        private ElasticsearchRestClientSyncAdvice() {
        }

        @Advice.OnMethodEnter(suppress=Throwable.class)
        private static void onBeforeExecute(@Advice.Argument(value=0) Request request, @Advice.Local(value="span") Span span, @Advice.Local(value="helper") ElasticsearchRestClientInstrumentationHelper<HttpEntity, Response, ResponseListener> helper) {
            helper = ElasticsearchRestClientInstrumentation.esClientInstrHelperManager.getForClassLoaderOfClass(Request.class);
            if (helper != null) {
                span = helper.createClientSpan(request.getMethod(), request.getEndpoint(), request.getEntity());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class)
        public static void onAfterExecute(@Advice.Return @Nullable Response response, @Advice.Local(value="span") @Nullable Span span, @Advice.Local(value="helper") @Nullable ElasticsearchRestClientInstrumentationHelper<HttpEntity, Response, ResponseListener> helper, @Advice.Thrown @Nullable Throwable t) {
            if (helper != null && span != null) {
                try {
                    helper.finishClientSpan(response, span, t);
                }
                finally {
                    span.deactivate();
                }
            }
        }
    }
}

