/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.httpclient;

import co.elastic.apm.agent.bci.ElasticApmInstrumentation;
import co.elastic.apm.agent.bci.HelperClassManager;
import co.elastic.apm.agent.bci.bytebuddy.CustomElementMatchers;
import co.elastic.apm.agent.httpclient.BaseApacheHttpClientInstrumentation;
import co.elastic.apm.agent.httpclient.helper.ApacheHttpAsyncClientHelper;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.TextHeaderSetter;
import co.elastic.apm.agent.impl.transaction.TraceContextHolder;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.NamedElement;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import javax.annotation.Nullable;
import org.apache.http.HttpRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import org.apache.http.protocol.HttpContext;

public class ApacheHttpAsyncClientInstrumentation
extends BaseApacheHttpClientInstrumentation {
    public static HelperClassManager<ApacheHttpAsyncClientHelper<HttpAsyncRequestProducer, FutureCallback<?>, HttpContext, HttpRequest>> asyncHelperManager;

    public ApacheHttpAsyncClientInstrumentation(ElasticApmTracer tracer) {
        super(tracer);
        asyncHelperManager = HelperClassManager.ForAnyClassLoader.of(tracer, "co.elastic.apm.agent.httpclient.helper.ApacheHttpAsyncClientHelperImpl", "co.elastic.apm.agent.httpclient.helper.HttpAsyncRequestProducerWrapper", "co.elastic.apm.agent.httpclient.helper.ApacheHttpAsyncClientHelperImpl$RequestProducerWrapperAllocator", "co.elastic.apm.agent.httpclient.helper.FutureCallbackWrapper", "co.elastic.apm.agent.httpclient.helper.ApacheHttpAsyncClientHelperImpl$FutureCallbackWrapperAllocator");
    }

    @Override
    public Class<?> getAdviceClass() {
        return ApacheHttpAsyncClientAdvice.class;
    }

    @Override
    public ElementMatcher.Junction<ClassLoader> getClassLoaderMatcher() {
        return ElementMatchers.not(ElementMatchers.isBootstrapClassLoader()).and(CustomElementMatchers.classLoaderCanLoadClass("org.apache.http.nio.client.HttpAsyncClient"));
    }

    @Override
    public ElementMatcher<? super NamedElement> getTypeMatcherPreFilter() {
        return ElementMatchers.nameContains("HttpAsyncClient");
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.hasSuperType(ElementMatchers.named("org.apache.http.nio.client.HttpAsyncClient"));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("execute").and(ElementMatchers.takesArguments(4)).and(ElementMatchers.takesArgument(0, ElementMatchers.named("org.apache.http.nio.protocol.HttpAsyncRequestProducer"))).and(ElementMatchers.takesArgument(1, ElementMatchers.named("org.apache.http.nio.protocol.HttpAsyncResponseConsumer"))).and(ElementMatchers.takesArgument(2, ElementMatchers.named("org.apache.http.protocol.HttpContext"))).and(ElementMatchers.takesArgument(3, ElementMatchers.named("org.apache.http.concurrent.FutureCallback")));
    }

    private static class ApacheHttpAsyncClientAdvice {
        private ApacheHttpAsyncClientAdvice() {
        }

        @Advice.OnMethodEnter(suppress=Throwable.class)
        private static void onBeforeExecute(@Advice.Argument(value=0, readOnly=false) HttpAsyncRequestProducer requestProducer, @Advice.Argument(value=2) HttpContext context, @Advice.Argument(value=3, readOnly=false) FutureCallback futureCallback, @Advice.Local(value="span") @Nullable Span span, @Advice.Local(value="wrapped") boolean wrapped) {
            if (ElasticApmInstrumentation.tracer == null || ElasticApmInstrumentation.tracer.getActive() == null) {
                return;
            }
            TraceContextHolder<?> parent = ElasticApmInstrumentation.tracer.getActive();
            span = parent.createExitSpan();
            if (span != null) {
                span.withType("external").withSubtype("http").activate();
                ApacheHttpAsyncClientHelper<HttpAsyncRequestProducer, FutureCallback<?>, HttpContext, HttpRequest> asyncHelper = asyncHelperManager.getForClassLoaderOfClass(HttpAsyncRequestProducer.class);
                TextHeaderSetter<HttpRequest> headerSetter = BaseApacheHttpClientInstrumentation.headerSetterHelperClassManager.getForClassLoaderOfClass(HttpRequest.class);
                if (asyncHelper != null && headerSetter != null) {
                    requestProducer = asyncHelper.wrapRequestProducer(requestProducer, span, headerSetter);
                    futureCallback = asyncHelper.wrapFutureCallback(futureCallback, context, span);
                    wrapped = true;
                }
            }
        }

        @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class)
        public static void onAfterExecute(@Advice.Local(value="span") @Nullable Span span, @Advice.Local(value="wrapped") boolean wrapped, @Advice.Thrown @Nullable Throwable t) {
            if (span != null) {
                span.deactivate();
                if (!wrapped) {
                    span.captureException(t);
                    span.end();
                }
            }
        }
    }
}

