/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.httpclient;

import co.elastic.apm.agent.bci.ElasticApmInstrumentation;
import co.elastic.apm.agent.bci.HelperClassManager;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.transaction.TextHeaderGetter;
import co.elastic.apm.agent.impl.transaction.TextHeaderSetter;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nullable;
import org.apache.http.HttpRequest;

public abstract class BaseApacheHttpClientInstrumentation
extends ElasticApmInstrumentation {
    @Nullable
    public static HelperClassManager<TextHeaderGetter<HttpRequest>> headerGetterHelperClassManager;
    @Nullable
    public static HelperClassManager<TextHeaderSetter<HttpRequest>> headerSetterHelperClassManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BaseApacheHttpClientInstrumentation(ElasticApmTracer tracer) {
        if (headerGetterHelperClassManager != null) return;
        Class<BaseApacheHttpClientInstrumentation> clazz = BaseApacheHttpClientInstrumentation.class;
        synchronized (BaseApacheHttpClientInstrumentation.class) {
            if (headerGetterHelperClassManager != null) return;
            headerGetterHelperClassManager = HelperClassManager.ForAnyClassLoader.of(tracer, "co.elastic.apm.agent.httpclient.helper.RequestHeaderAccessor", new String[0]);
            headerSetterHelperClassManager = HelperClassManager.ForAnyClassLoader.of(tracer, "co.elastic.apm.agent.httpclient.helper.RequestHeaderAccessor", new String[0]);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Arrays.asList("http-client", "apache-httpclient");
    }
}

