/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.impl.async;

import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.transaction.TraceContext;
import co.elastic.apm.agent.objectpool.Recyclable;
import co.elastic.apm.agent.shaded.slf4j.Logger;
import co.elastic.apm.agent.shaded.slf4j.LoggerFactory;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;

public class ContextInScopeCallableWrapper<V>
implements Callable<V>,
Recyclable {
    private static final Logger logger = LoggerFactory.getLogger(ContextInScopeCallableWrapper.class);
    private final ElasticApmTracer tracer;
    private final TraceContext context;
    @Nullable
    private volatile Callable<V> delegate;

    public ContextInScopeCallableWrapper(ElasticApmTracer tracer) {
        this.tracer = tracer;
        this.context = TraceContext.with64BitId(tracer);
    }

    public ContextInScopeCallableWrapper<V> wrap(Callable<V> delegate, TraceContext context) {
        this.context.copyFrom(context);
        this.delegate = delegate;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V call() throws Exception {
        try {
            this.context.activate();
        }
        catch (Throwable t) {
            try {
                logger.error("Unexpected error while activating span", t);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        V v = this.delegate.call();
        return v;
        finally {
            try {
                this.context.deactivate();
                this.tracer.recycle(this);
            }
            catch (Throwable t) {
                try {
                    logger.error("Unexpected error while deactivating or recycling span", t);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    @Override
    public void resetState() {
        this.context.resetState();
        this.delegate = null;
    }
}

