/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.impl.async;

import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.transaction.TraceContext;
import co.elastic.apm.agent.objectpool.Recyclable;
import co.elastic.apm.agent.shaded.slf4j.Logger;
import co.elastic.apm.agent.shaded.slf4j.LoggerFactory;
import javax.annotation.Nullable;

public class ContextInScopeRunnableWrapper
implements Runnable,
Recyclable {
    private static final Logger logger = LoggerFactory.getLogger(ContextInScopeRunnableWrapper.class);
    private final ElasticApmTracer tracer;
    private final TraceContext context;
    @Nullable
    private volatile Runnable delegate;

    public ContextInScopeRunnableWrapper(ElasticApmTracer tracer) {
        this.tracer = tracer;
        this.context = TraceContext.with64BitId(tracer);
    }

    public ContextInScopeRunnableWrapper wrap(Runnable delegate, TraceContext context) {
        this.context.copyFrom(context);
        this.delegate = delegate;
        return this;
    }

    @Override
    public void run() {
        try {
            this.context.activate();
        }
        catch (Throwable t) {
            try {
                logger.error("Unexpected error while activating span", t);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        try {
            this.delegate.run();
        }
        finally {
            try {
                this.context.deactivate();
                this.tracer.recycle(this);
            }
            catch (Throwable t) {
                try {
                    logger.error("Unexpected error while deactivating or recycling span", t);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    @Override
    public void resetState() {
        this.context.resetState();
        this.delegate = null;
    }
}

