/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.impl.async;

import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.async.SpanInScopeBaseWrapper;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.objectpool.Recyclable;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;

public class SpanInScopeCallableWrapper<V>
extends SpanInScopeBaseWrapper
implements Callable<V>,
Recyclable {
    @Nullable
    private volatile Callable<V> delegate;
    @Nullable
    private volatile AbstractSpan<?> span;

    public SpanInScopeCallableWrapper(ElasticApmTracer tracer) {
        super(tracer);
    }

    public SpanInScopeCallableWrapper<V> wrap(Callable<V> delegate, AbstractSpan<?> span) {
        this.delegate = delegate;
        this.span = span;
        span.incrementReferences();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V call() throws Exception {
        AbstractSpan<?> localSpan = this.span;
        boolean activated = this.beforeDelegation(localSpan);
        try {
            V v = this.delegate.call();
            return v;
        }
        finally {
            this.afterDelegation(localSpan, activated);
        }
    }

    @Override
    public void resetState() {
        this.delegate = null;
        this.span = null;
    }

    @Override
    protected void doRecycle() {
        this.tracer.recycle(this);
    }
}

