/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.impl.context;

import co.elastic.apm.agent.impl.context.Socket;
import co.elastic.apm.agent.impl.context.Url;
import co.elastic.apm.agent.objectpool.Allocator;
import co.elastic.apm.agent.objectpool.ObjectPool;
import co.elastic.apm.agent.objectpool.Recyclable;
import co.elastic.apm.agent.objectpool.Resetter;
import co.elastic.apm.agent.objectpool.impl.QueueBasedObjectPool;
import co.elastic.apm.agent.shaded.jctools.queues.atomic.MpmcAtomicArrayQueue;
import co.elastic.apm.agent.util.PotentiallyMultiValuedMap;
import java.nio.Buffer;
import java.nio.CharBuffer;
import java.util.Enumeration;
import javax.annotation.Nullable;

public class Request
implements Recyclable {
    private static final ObjectPool<CharBuffer> charBufferPool = QueueBasedObjectPool.of(new MpmcAtomicArrayQueue(128), false, new Allocator<CharBuffer>(){

        @Override
        public CharBuffer createInstance() {
            return CharBuffer.allocate(10000);
        }
    }, new Resetter<CharBuffer>(){

        @Override
        public void recycle(CharBuffer object) {
            ((Buffer)object).clear();
        }
    });
    private final PotentiallyMultiValuedMap postParams = new PotentiallyMultiValuedMap();
    private final PotentiallyMultiValuedMap headers = new PotentiallyMultiValuedMap();
    private final Socket socket = new Socket();
    private final Url url = new Url();
    private final PotentiallyMultiValuedMap cookies = new PotentiallyMultiValuedMap();
    @Nullable
    private String rawBody;
    @Nullable
    private String httpVersion;
    @Nullable
    private String method;
    @Nullable
    private CharBuffer bodyBuffer;
    private boolean bodyBufferFinished = false;

    @Nullable
    public Object getBody() {
        if (!this.postParams.isEmpty()) {
            return this.postParams;
        }
        if (this.rawBody != null) {
            return this.rawBody;
        }
        return this.bodyBuffer;
    }

    @Nullable
    public String getRawBody() {
        return this.rawBody;
    }

    public void setRawBody(String rawBody) {
        this.postParams.resetState();
        if (this.bodyBuffer != null) {
            charBufferPool.recycle(this.bodyBuffer);
            this.bodyBuffer = null;
        }
        this.rawBody = rawBody;
    }

    public void redactBody() {
        this.setRawBody("[REDACTED]");
    }

    public Request addFormUrlEncodedParameter(String key, String value) {
        this.postParams.add(key, value);
        return this;
    }

    public Request addFormUrlEncodedParameters(String key, String[] values) {
        this.postParams.set(key, values);
        return this;
    }

    public CharBuffer withBodyBuffer() {
        if (this.bodyBuffer == null) {
            this.bodyBuffer = charBufferPool.createInstance();
        }
        return this.bodyBuffer;
    }

    public void endOfBufferInput() {
        if (this.bodyBuffer != null && !this.bodyBufferFinished) {
            this.bodyBufferFinished = true;
            ((Buffer)this.bodyBuffer).flip();
        }
    }

    @Nullable
    public CharBuffer getBodyBuffer() {
        if (!this.bodyBufferFinished) {
            return this.bodyBuffer;
        }
        return null;
    }

    @Nullable
    public CharBuffer getBodyBufferForSerialization() {
        return this.bodyBuffer;
    }

    public PotentiallyMultiValuedMap getFormUrlEncodedParameters() {
        return this.postParams;
    }

    public Request addHeader(String headerName, @Nullable String headerValue) {
        if (headerValue != null) {
            this.headers.add(headerName, headerValue);
        }
        return this;
    }

    public Request addHeader(String headerName, @Nullable Enumeration<String> headerValues) {
        if (headerValues != null) {
            while (headerValues.hasMoreElements()) {
                this.headers.add(headerName, headerValues.nextElement());
            }
        }
        return this;
    }

    public PotentiallyMultiValuedMap getHeaders() {
        return this.headers;
    }

    @Nullable
    public String getHttpVersion() {
        return this.httpVersion;
    }

    public Request withHttpVersion(@Nullable String httpVersion) {
        this.httpVersion = httpVersion;
        return this;
    }

    @Nullable
    public String getMethod() {
        return this.method;
    }

    public Request withMethod(@Nullable String method) {
        this.method = method;
        return this;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public Url getUrl() {
        return this.url;
    }

    public Request addCookie(String cookieName, String cookieValue) {
        this.cookies.add(cookieName, cookieValue);
        return this;
    }

    public PotentiallyMultiValuedMap getCookies() {
        return this.cookies;
    }

    void onTransactionEnd() {
        this.endOfBufferInput();
    }

    @Override
    public void resetState() {
        this.postParams.resetState();
        this.headers.resetState();
        this.httpVersion = null;
        this.method = null;
        this.socket.resetState();
        this.url.resetState();
        this.cookies.resetState();
        this.bodyBufferFinished = false;
        if (this.bodyBuffer != null) {
            charBufferPool.recycle(this.bodyBuffer);
            this.bodyBuffer = null;
        }
    }

    public void copyFrom(Request other) {
        this.postParams.copyFrom(other.postParams);
        this.headers.copyFrom(other.headers);
        this.httpVersion = other.httpVersion;
        this.method = other.method;
        this.socket.copyFrom(other.socket);
        this.url.copyFrom(other.url);
        this.cookies.copyFrom(other.cookies);
        if (other.bodyBuffer != null) {
            CharBuffer otherBuffer = other.bodyBuffer;
            CharBuffer thisBuffer = this.withBodyBuffer();
            for (int i = 0; i < otherBuffer.length(); ++i) {
                thisBuffer.append(otherBuffer.charAt(i));
            }
            ((Buffer)thisBuffer).flip();
        }
    }

    public boolean hasContent() {
        return this.method != null || this.headers.size() > 0 || this.httpVersion != null || this.cookies.size() > 0 || this.postParams.size() > 0 || this.socket.hasContent() || this.url.hasContent();
    }
}

