/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.impl.context;

import co.elastic.apm.agent.objectpool.Recyclable;
import co.elastic.apm.agent.util.PotentiallyMultiValuedMap;
import java.util.Collection;
import javax.annotation.Nullable;

public class Response
implements Recyclable {
    private final PotentiallyMultiValuedMap headers = new PotentiallyMultiValuedMap();
    private boolean finished;
    private boolean headersSent;
    private int statusCode;

    public boolean isFinished() {
        return this.finished;
    }

    public Response withFinished(boolean finished) {
        this.finished = finished;
        return this;
    }

    public Response addHeader(String headerName, String headerValue) {
        this.headers.add(headerName, headerValue);
        return this;
    }

    public Response addHeader(String headerName, @Nullable Collection<String> headerValues) {
        if (headerValues != null) {
            for (String headerValue : headerValues) {
                this.headers.add(headerName, headerValue);
            }
        }
        return this;
    }

    public PotentiallyMultiValuedMap getHeaders() {
        return this.headers;
    }

    public boolean isHeadersSent() {
        return this.headersSent;
    }

    public Response withHeadersSent(boolean headersSent) {
        this.headersSent = headersSent;
        return this;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public Response withStatusCode(int statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    @Override
    public void resetState() {
        this.finished = false;
        this.headers.resetState();
        this.headersSent = false;
        this.statusCode = 0;
    }

    public void copyFrom(Response other) {
        this.finished = other.finished;
        this.headers.copyFrom(other.headers);
        this.headersSent = other.headersSent;
        this.statusCode = other.statusCode;
    }

    public boolean hasContent() {
        return this.statusCode > 0 || this.headers.size() > 0;
    }
}

