/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.impl.error;

import co.elastic.apm.agent.configuration.CoreConfiguration;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.context.TransactionContext;
import co.elastic.apm.agent.impl.stacktrace.StacktraceConfiguration;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.TraceContext;
import co.elastic.apm.agent.impl.transaction.TraceContextHolder;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.matcher.WildcardMatcher;
import co.elastic.apm.agent.objectpool.Recyclable;
import java.util.Collection;
import javax.annotation.Nullable;

public class ErrorCapture
implements Recyclable {
    private final TraceContext traceContext;
    private final TransactionContext context = new TransactionContext();
    @Nullable
    private Throwable exception;
    private long timestamp;
    private TransactionInfo transactionInfo = new TransactionInfo();
    private ElasticApmTracer tracer;
    private final StringBuilder culprit = new StringBuilder();

    public ErrorCapture(ElasticApmTracer tracer) {
        this.tracer = tracer;
        this.traceContext = TraceContext.with128BitId(this.tracer);
    }

    public TransactionContext getContext() {
        return this.context;
    }

    @Nullable
    public Throwable getException() {
        return this.exception;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public ErrorCapture withTimestamp(long epochMs) {
        this.timestamp = epochMs;
        return this;
    }

    @Override
    public void resetState() {
        this.exception = null;
        this.context.resetState();
        this.timestamp = 0L;
        this.transactionInfo.resetState();
        this.traceContext.resetState();
        this.culprit.setLength(0);
    }

    public void recycle() {
        this.tracer.recycle(this);
    }

    public ErrorCapture asChildOf(TraceContextHolder<?> parent) {
        this.traceContext.asChildOf(parent.getTraceContext());
        if (parent instanceof Transaction) {
            Transaction transaction = (Transaction)parent;
            this.context.copyFrom(transaction.getContextEnsureVisibility());
        } else if (parent instanceof Span) {
            Span span = (Span)parent;
            this.context.copyFrom(span.getContext());
        }
        return this;
    }

    public TraceContext getTraceContext() {
        return this.traceContext;
    }

    public void setException(Throwable e) {
        this.exception = WildcardMatcher.anyMatch(this.tracer.getConfig(CoreConfiguration.class).getUnnestExceptions(), e.getClass().getName()) != null ? e.getCause() : e;
    }

    public StringBuilder getCulprit() {
        Collection<String> applicationPackages = this.tracer.getConfig(StacktraceConfiguration.class).getApplicationPackages();
        if (this.exception != null && this.culprit.length() == 0 && !applicationPackages.isEmpty()) {
            this.computeCulprit(this.exception, applicationPackages);
        }
        return this.culprit;
    }

    private void computeCulprit(Throwable exception, Collection<String> applicationPackages) {
        if (exception.getCause() != null) {
            this.computeCulprit(exception.getCause(), applicationPackages);
        }
        if (this.culprit.length() > 0) {
            return;
        }
        for (StackTraceElement stackTraceElement : exception.getStackTrace()) {
            for (String applicationPackage : applicationPackages) {
                if (!stackTraceElement.getClassName().startsWith(applicationPackage)) continue;
                this.setCulprit(stackTraceElement);
                return;
            }
        }
    }

    private void setCulprit(StackTraceElement stackTraceElement) {
        int lineNumber = stackTraceElement.getLineNumber();
        String fileName = stackTraceElement.getFileName();
        this.culprit.append(stackTraceElement.getClassName()).append('.').append(stackTraceElement.getMethodName()).append('(');
        if (stackTraceElement.isNativeMethod()) {
            this.culprit.append("Native Method");
        } else {
            this.culprit.append(fileName != null ? fileName : "Unknown Source");
            if (lineNumber > 0) {
                this.culprit.append(':').append(lineNumber);
            }
        }
        this.culprit.append(')');
    }

    public TransactionInfo getTransactionInfo() {
        return this.transactionInfo;
    }

    public void setTransactionSampled(boolean transactionSampled) {
        this.transactionInfo.isSampled = transactionSampled;
    }

    public void setTransactionType(@Nullable String type) {
        this.transactionInfo.type = type;
    }

    public static class TransactionInfo
    implements Recyclable {
        private boolean isSampled;
        @Nullable
        private String type;

        @Override
        public void resetState() {
            this.isSampled = false;
            this.type = null;
        }

        public boolean isSampled() {
            return this.isSampled;
        }

        @Nullable
        public String getType() {
            return this.type;
        }
    }
}

