/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.impl.payload;

import co.elastic.apm.agent.configuration.CoreConfiguration;
import co.elastic.apm.agent.impl.payload.Agent;
import co.elastic.apm.agent.impl.payload.Framework;
import co.elastic.apm.agent.impl.payload.Language;
import co.elastic.apm.agent.impl.payload.Node;
import co.elastic.apm.agent.impl.payload.RuntimeInfo;
import co.elastic.apm.agent.impl.payload.Service;
import co.elastic.apm.agent.util.VersionUtils;
import javax.annotation.Nullable;

public class ServiceFactory {
    public Service createService(CoreConfiguration coreConfiguration, @Nullable String frameworkName, @Nullable String frameworkVersion) {
        Service service = new Service().withName(coreConfiguration.getServiceName()).withVersion(coreConfiguration.getServiceVersion()).withEnvironment(coreConfiguration.getEnvironment()).withAgent(new Agent("java", this.getAgentVersion())).withRuntime(new RuntimeInfo("Java", System.getProperty("java.version"))).withLanguage(new Language("Java", System.getProperty("java.version"))).withNode(new Node(coreConfiguration.getServiceNodeName()));
        if (frameworkName != null && frameworkVersion != null) {
            service.withFramework(new Framework(frameworkName, frameworkVersion));
        }
        return service;
    }

    private String getAgentVersion() {
        String version = VersionUtils.getVersionFromPomProperties(ServiceFactory.class, "co.elastic.apm", "elastic-apm-agent");
        if (version == null) {
            return "unknown";
        }
        return version;
    }
}

