/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.impl.transaction;

import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.context.SpanContext;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.StackFrame;
import co.elastic.apm.agent.impl.transaction.TraceContext;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.objectpool.Recyclable;
import co.elastic.apm.agent.shaded.slf4j.Logger;
import co.elastic.apm.agent.shaded.slf4j.LoggerFactory;
import java.util.List;
import javax.annotation.Nullable;

public class Span
extends AbstractSpan<Span>
implements Recyclable {
    private static final Logger logger = LoggerFactory.getLogger(Span.class);
    @Nullable
    private String type;
    @Nullable
    private String subtype;
    @Nullable
    private String action;
    private final SpanContext context = new SpanContext();
    @Nullable
    private Throwable stacktrace;
    @Nullable
    private AbstractSpan<?> parent;
    @Nullable
    private Transaction transaction;
    @Nullable
    private List<StackFrame> stackFrames;

    public Span(ElasticApmTracer tracer) {
        super(tracer);
    }

    public <T> Span start(TraceContext.ChildContextCreator<T> childContextCreator, T parentContext, long epochMicros, boolean dropped) {
        childContextCreator.asChildOf(this.traceContext, parentContext);
        if (parentContext instanceof Transaction) {
            this.parent = this.transaction = (Transaction)parentContext;
        } else if (parentContext instanceof Span) {
            Span parentSpan;
            this.parent = parentSpan = (Span)parentContext;
            this.transaction = parentSpan.transaction;
        }
        return this.start(epochMicros, dropped);
    }

    private Span start(long epochMicros, boolean dropped) {
        if (dropped) {
            this.traceContext.setRecorded(false);
        }
        if (epochMicros >= 0L) {
            this.setStartTimestamp(epochMicros);
        } else {
            this.setStartTimestampNow();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("startSpan {} {", (Object)this);
            if (logger.isTraceEnabled()) {
                logger.trace("starting span at", new RuntimeException("this exception is just used to record where the span has been started from"));
            }
        }
        this.onAfterStart();
        return this;
    }

    @Override
    protected void onAfterStart() {
        super.onAfterStart();
        if (this.parent != null) {
            this.parent.incrementReferences();
            this.parent.onChildStart(this.getTimestamp());
        }
    }

    @Override
    public SpanContext getContext() {
        return this.context;
    }

    public Span withType(@Nullable String type) {
        this.type = type;
        return this;
    }

    public Span withSubtype(@Nullable String subtype) {
        this.subtype = subtype;
        return this;
    }

    public Span withAction(@Nullable String action) {
        this.action = action;
        return this;
    }

    @Deprecated
    public void setType(@Nullable String type, @Nullable String subtype, @Nullable String action) {
        String temp;
        int indexOfFirstDot;
        if (type != null && (subtype == null || subtype.isEmpty()) && (action == null || action.isEmpty()) && (indexOfFirstDot = (temp = type).indexOf(".")) > 0) {
            type = temp.substring(0, indexOfFirstDot);
            int indexOfSecondDot = temp.indexOf(".", indexOfFirstDot + 1);
            if (indexOfSecondDot > 0) {
                subtype = temp.substring(indexOfFirstDot + 1, indexOfSecondDot);
                if (indexOfSecondDot + 1 < temp.length()) {
                    action = temp.substring(indexOfSecondDot + 1);
                }
            }
        }
        this.type = type;
        this.subtype = subtype;
        this.action = action;
    }

    @Nullable
    public Throwable getStacktrace() {
        return this.stacktrace;
    }

    @Nullable
    public String getType() {
        return this.type;
    }

    @Nullable
    public String getSubtype() {
        return this.subtype;
    }

    @Nullable
    public String getAction() {
        return this.action;
    }

    @Override
    public void beforeEnd(long epochMicros) {
        if (logger.isDebugEnabled()) {
            logger.debug("endSpan {}", (Object)this);
            if (logger.isTraceEnabled()) {
                logger.trace("ending span at", new RuntimeException("this exception is just used to record where the span has been ended from"));
            }
        }
        if (this.type == null) {
            this.type = "custom";
        }
        if (this.transaction != null) {
            this.transaction.incrementTimer(this.type, this.subtype, this.getSelfDuration());
        }
        if (this.parent != null) {
            this.parent.onChildEnd(epochMicros);
            this.parent.decrementReferences();
        }
    }

    @Override
    protected void afterEnd() {
        this.tracer.endSpan(this);
    }

    @Override
    public void resetState() {
        super.resetState();
        this.context.resetState();
        this.stacktrace = null;
        this.type = null;
        this.subtype = null;
        this.action = null;
        this.parent = null;
        this.transaction = null;
        this.stackFrames = null;
    }

    public String toString() {
        return String.format("'%s' %s (%s)", this.name, this.traceContext, Integer.toHexString(System.identityHashCode(this)));
    }

    public Span withStacktrace(Throwable stacktrace) {
        this.stacktrace = stacktrace;
        return this;
    }

    @Override
    public void incrementReferences() {
        if (this.transaction != null) {
            this.transaction.incrementReferences();
        }
        super.incrementReferences();
    }

    @Override
    public void decrementReferences() {
        if (this.transaction != null) {
            this.transaction.decrementReferences();
        }
        super.decrementReferences();
    }

    @Override
    protected void recycle() {
        this.tracer.recycle(this);
    }

    public void setStackTrace(List<StackFrame> stackTrace) {
        this.stackFrames = stackTrace;
    }

    @Nullable
    public List<StackFrame> getStackFrames() {
        return this.stackFrames;
    }
}

