/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.impl.transaction;

import co.elastic.apm.agent.impl.ActivationListener;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.Scope;
import co.elastic.apm.agent.impl.error.ErrorCapture;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.TraceContext;
import co.elastic.apm.agent.objectpool.Recyclable;
import co.elastic.apm.agent.shaded.slf4j.Logger;
import co.elastic.apm.agent.shaded.slf4j.LoggerFactory;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;

public abstract class TraceContextHolder<T extends TraceContextHolder>
implements Recyclable {
    private static final Logger logger = LoggerFactory.getLogger(TraceContextHolder.class);
    protected final ElasticApmTracer tracer;
    private boolean isExit;

    protected TraceContextHolder(ElasticApmTracer tracer) {
        this.tracer = tracer;
    }

    public TraceContextHolder<T> asExit() {
        this.isExit = true;
        return this;
    }

    public abstract TraceContext getTraceContext();

    public abstract Span createSpan();

    public abstract Span createSpan(long var1);

    @Nullable
    public Span createExitSpan() {
        if (this.isExit) {
            return null;
        }
        return (Span)this.createSpan().asExit();
    }

    public abstract boolean isChildOf(TraceContextHolder var1);

    public T activate() {
        List<ActivationListener> activationListeners = this.tracer.getActivationListeners();
        for (int i = 0; i < activationListeners.size(); ++i) {
            try {
                activationListeners.get(i).beforeActivate(this);
                continue;
            }
            catch (Error e) {
                throw e;
            }
            catch (Throwable t) {
                logger.warn("Exception while calling {}#beforeActivate", (Object)activationListeners.get(i).getClass().getSimpleName(), (Object)t);
            }
        }
        this.tracer.activate(this);
        return (T)this;
    }

    public T deactivate() {
        this.tracer.deactivate(this);
        List<ActivationListener> activationListeners = this.tracer.getActivationListeners();
        for (int i = 0; i < activationListeners.size(); ++i) {
            try {
                activationListeners.get(i).afterDeactivate(this);
                continue;
            }
            catch (Error e) {
                throw e;
            }
            catch (Throwable t) {
                logger.warn("Exception while calling {}#afterDeactivate", (Object)activationListeners.get(i).getClass().getSimpleName(), (Object)t);
            }
        }
        return (T)this;
    }

    public Scope activateInScope() {
        if (this.tracer.getActive() == this) {
            return Scope.NoopScope.INSTANCE;
        }
        this.activate();
        return new Scope(){

            @Override
            public void close() {
                TraceContextHolder.this.deactivate();
            }
        };
    }

    public boolean isSampled() {
        return this.getTraceContext().isSampled();
    }

    public boolean isExit() {
        return this.isExit;
    }

    public void setDiscard(boolean discard) {
        this.getTraceContext().setDiscard(discard);
    }

    public boolean isDiscard() {
        return this.getTraceContext().isDiscard();
    }

    public void captureException(long epochMicros, Throwable t) {
        this.tracer.captureException(epochMicros, t, this);
    }

    public T captureException(@Nullable Throwable t) {
        if (t != null) {
            this.captureException(this.getTraceContext().getClock().getEpochMicros(), t);
        }
        return (T)this;
    }

    @Nullable
    public String captureExceptionAndGetErrorId(@Nullable Throwable t) {
        ErrorCapture errorCapture = this.tracer.captureException(this.getTraceContext().getClock().getEpochMicros(), t, this);
        return errorCapture != null ? errorCapture.getTraceContext().getId().toString() : null;
    }

    public abstract Runnable withActive(Runnable var1);

    public abstract <V> Callable<V> withActive(Callable<V> var1);

    @Override
    public void resetState() {
        this.isExit = false;
    }
}

