/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.jdbc;

import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.jdbc.JdbcInstrumentation;
import co.elastic.apm.agent.jdbc.helper.JdbcHelper;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.NamedElement;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import java.sql.Statement;
import javax.annotation.Nullable;

public abstract class StatementInstrumentation
extends JdbcInstrumentation {
    private final ElementMatcher<? super MethodDescription> methodMatcher;

    StatementInstrumentation(ElasticApmTracer tracer, ElementMatcher<? super MethodDescription> methodMatcher) {
        super(tracer);
        this.methodMatcher = methodMatcher;
    }

    @Override
    public ElementMatcher<? super NamedElement> getTypeMatcherPreFilter() {
        return ElementMatchers.nameContains("Statement").or(ElementMatchers.nameStartsWith("com.ibm.db2.jcc"));
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.not(ElementMatchers.isInterface()).and(ElementMatchers.hasSuperType(ElementMatchers.named("java.sql.Statement")));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return this.methodMatcher;
    }

    public static class ExecutePreparedStatementInstrumentation
    extends StatementInstrumentation {
        public ExecutePreparedStatementInstrumentation(ElasticApmTracer tracer) {
            super(tracer, ElementMatchers.named("execute").or(ElementMatchers.named("executeQuery")).and(ElementMatchers.takesArguments(0)).and(ElementMatchers.isPublic()));
        }

        @Nullable
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static Span onBeforeExecute(@Advice.This Statement statement) {
            JdbcHelper helperImpl;
            if (tracer != null && jdbcHelperManager != null && (helperImpl = (JdbcHelper)jdbcHelperManager.getForClassLoaderOfClass(Statement.class)) != null) {
                String sql = helperImpl.retrieveSqlForStatement(statement);
                return helperImpl.createJdbcSpan(sql, statement, tracer.getActive(), true);
            }
            return null;
        }

        @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class)
        public static void onAfterExecute(@Advice.This Statement statement, @Advice.Enter @Nullable Span span, @Advice.Thrown @Nullable Throwable t) {
            JdbcHelper jdbcHelper;
            if (span == null) {
                return;
            }
            if (t == null && jdbcHelperManager != null && (jdbcHelper = (JdbcHelper)jdbcHelperManager.getForClassLoaderOfClass(Statement.class)) != null) {
                span.getContext().getDb().withAffectedRowsCount(jdbcHelper.safeGetUpdateCount(statement));
            }
            ((Span)((Span)span.captureException(t)).deactivate()).end();
        }
    }

    public static class ExecuteUpdateNoQueryInstrumentation
    extends StatementInstrumentation {
        public ExecuteUpdateNoQueryInstrumentation(ElasticApmTracer tracer) {
            super(tracer, ElementMatchers.named("executeUpdate").or(ElementMatchers.named("executeLargeUpdate")).and(ElementMatchers.takesArguments(0)).and(ElementMatchers.isPublic()));
        }

        @Nullable
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static Span onBeforeExecute(@Advice.This Statement statement) {
            if (tracer == null || jdbcHelperManager == null) {
                return null;
            }
            JdbcHelper helperImpl = (JdbcHelper)jdbcHelperManager.getForClassLoaderOfClass(Statement.class);
            if (helperImpl == null) {
                return null;
            }
            String sql = helperImpl.retrieveSqlForStatement(statement);
            return helperImpl.createJdbcSpan(sql, statement, tracer.getActive(), true);
        }

        @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class)
        public static void onAfterExecute(@Advice.Enter @Nullable Span span, @Advice.Thrown @Nullable Throwable t, @Advice.Return long returnValue) {
            if (span == null) {
                return;
            }
            if (t == null) {
                span.getContext().getDb().withAffectedRowsCount(returnValue);
            }
            ((Span)((Span)span.captureException(t)).deactivate()).end();
        }
    }

    public static class ExecuteBatchInstrumentation
    extends StatementInstrumentation {
        public ExecuteBatchInstrumentation(ElasticApmTracer tracer) {
            super(tracer, ElementMatchers.named("executeBatch").or(ElementMatchers.named("executeLargeBatch")).and(ElementMatchers.takesArguments(0)).and(ElementMatchers.isPublic()));
        }

        @Nullable
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static Span onBeforeExecute(@Advice.This Statement statement) {
            if (tracer == null || jdbcHelperManager == null) {
                return null;
            }
            JdbcHelper helper = (JdbcHelper)jdbcHelperManager.getForClassLoaderOfClass(Statement.class);
            if (helper == null) {
                return null;
            }
            String sql = helper.retrieveSqlForStatement(statement);
            return helper.createJdbcSpan(sql, statement, tracer.getActive(), true);
        }

        @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class)
        public static void onAfterExecute(@Advice.Enter @Nullable Span span, @Advice.Thrown Throwable t, @Advice.Return Object returnValue) {
            if (span == null) {
                return;
            }
            long affectedCount = 0L;
            if (returnValue instanceof int[]) {
                int[] array = (int[])returnValue;
                for (int i = 0; i < array.length; ++i) {
                    affectedCount += (long)array[i];
                }
            } else if (returnValue instanceof long[]) {
                long[] array = (long[])returnValue;
                for (int i = 0; i < array.length; ++i) {
                    affectedCount += array[i];
                }
            }
            span.getContext().getDb().withAffectedRowsCount(affectedCount);
            ((Span)((Span)span.captureException(t)).deactivate()).end();
        }
    }

    public static class AddBatchInstrumentation
    extends StatementInstrumentation {
        public AddBatchInstrumentation(ElasticApmTracer tracer) {
            super(tracer, ElementMatchers.nameStartsWith("addBatch").and(ElementMatchers.takesArgument(0, String.class)).and(ElementMatchers.isPublic()));
        }

        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static void storeSql(@Advice.This Statement statement, @Advice.Argument(value=0) String sql) {
            if (jdbcHelperManager == null) {
                return;
            }
            JdbcHelper helperImpl = (JdbcHelper)jdbcHelperManager.getForClassLoaderOfClass(Statement.class);
            if (helperImpl != null) {
                helperImpl.mapStatementToSql(statement, sql);
            }
        }
    }

    public static class ExecuteUpdateWithQueryInstrumentation
    extends StatementInstrumentation {
        public ExecuteUpdateWithQueryInstrumentation(ElasticApmTracer tracer) {
            super(tracer, ElementMatchers.named("executeUpdate").or(ElementMatchers.named("executeLargeUpdate")).and(ElementMatchers.takesArgument(0, String.class)).and(ElementMatchers.isPublic()));
        }

        @Nullable
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static Span onBeforeExecute(@Advice.This Statement statement, @Advice.Argument(value=0) String sql) {
            if (tracer == null || jdbcHelperManager == null) {
                return null;
            }
            JdbcHelper helperImpl = (JdbcHelper)jdbcHelperManager.getForClassLoaderOfClass(Statement.class);
            if (helperImpl == null) {
                return null;
            }
            return helperImpl.createJdbcSpan(sql, statement, tracer.getActive(), false);
        }

        @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class)
        public static void onAfterExecute(@Advice.Enter @Nullable Span span, @Advice.Thrown @Nullable Throwable t, @Advice.Return long returnValue) {
            if (span == null) {
                return;
            }
            if (t == null) {
                span.getContext().getDb().withAffectedRowsCount(returnValue);
            }
            ((Span)((Span)span.captureException(t)).deactivate()).end();
        }
    }

    public static class ExecuteWithQueryInstrumentation
    extends StatementInstrumentation {
        public ExecuteWithQueryInstrumentation(ElasticApmTracer tracer) {
            super(tracer, ElementMatchers.named("execute").or(ElementMatchers.named("executeQuery")).and(ElementMatchers.takesArgument(0, String.class)).and(ElementMatchers.isPublic()));
        }

        @Nullable
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static Span onBeforeExecute(@Advice.This Statement statement, @Advice.Argument(value=0) String sql) {
            if (tracer == null || jdbcHelperManager == null) {
                return null;
            }
            JdbcHelper helperImpl = (JdbcHelper)jdbcHelperManager.getForClassLoaderOfClass(Statement.class);
            if (helperImpl == null) {
                return null;
            }
            return helperImpl.createJdbcSpan(sql, statement, tracer.getActive(), false);
        }

        @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class)
        public static void onAfterExecute(@Advice.This Statement statement, @Advice.Enter @Nullable Span span, @Advice.Thrown @Nullable Throwable t) {
            long count;
            JdbcHelper helper;
            if (span == null) {
                return;
            }
            if (t == null && jdbcHelperManager != null && (helper = (JdbcHelper)jdbcHelperManager.getForClassLoaderOfClass(Statement.class)) != null && (count = helper.safeGetUpdateCount(statement)) != Long.MIN_VALUE) {
                span.getContext().getDb().withAffectedRowsCount(count);
            }
            ((Span)((Span)span.captureException(t)).deactivate()).end();
        }
    }
}

