/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.kafka;

import co.elastic.apm.agent.bci.ElasticApmInstrumentation;
import co.elastic.apm.agent.bci.HelperClassManager;
import co.elastic.apm.agent.bci.bytebuddy.CustomElementMatchers;
import co.elastic.apm.agent.configuration.MessagingConfiguration;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.kafka.helper.KafkaInstrumentationHelper;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;

public abstract class BaseKafkaInstrumentation
extends ElasticApmInstrumentation {
    @Nullable
    public static HelperClassManager<KafkaInstrumentationHelper<Callback, ProducerRecord, KafkaProducer>> kafkaInstrHelperManager;
    public static MessagingConfiguration messagingConfiguration;

    private static synchronized void init(ElasticApmTracer tracer) {
        if (kafkaInstrHelperManager == null) {
            kafkaInstrHelperManager = HelperClassManager.ForAnyClassLoader.of(tracer, "co.elastic.apm.agent.kafka.helper.KafkaInstrumentationHelperImpl", "co.elastic.apm.agent.kafka.helper.KafkaInstrumentationHelperImpl$CallbackWrapperAllocator", "co.elastic.apm.agent.kafka.helper.CallbackWrapper");
        }
        messagingConfiguration = tracer.getConfig(MessagingConfiguration.class);
    }

    BaseKafkaInstrumentation(ElasticApmTracer tracer) {
        BaseKafkaInstrumentation.init(tracer);
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Collections.singletonList("kafka");
    }

    @Override
    public ElementMatcher.Junction<ClassLoader> getClassLoaderMatcher() {
        return ElementMatchers.not(ElementMatchers.isBootstrapClassLoader()).and(CustomElementMatchers.classLoaderCanLoadClass("org.apache.kafka.clients.consumer.ConsumerRecord"));
    }
}

