/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.kafka;

import co.elastic.apm.agent.bci.ElasticApmInstrumentation;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.kafka.BaseKafkaHeadersInstrumentation;
import co.elastic.apm.agent.kafka.KafkaConsumerRecordsInstrumentation;
import co.elastic.apm.agent.kafka.helper.KafkaInstrumentationHeadersHelper;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;

public class ConsumerRecordsIteratorInstrumentation
extends KafkaConsumerRecordsInstrumentation {
    public ConsumerRecordsIteratorInstrumentation(ElasticApmTracer tracer) {
        super(tracer);
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("iterator").and(ElementMatchers.isPublic()).and(ElementMatchers.takesArguments(0)).and(ElementMatchers.returns(Iterator.class));
    }

    @Override
    public Class<?> getAdviceClass() {
        return ConsumerRecordsAdvice.class;
    }

    public static class ConsumerRecordsAdvice {
        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
        public static void wrapIterator(@Nullable @Advice.Return(readOnly=false) Iterator<ConsumerRecord> iterator) {
            if (ElasticApmInstrumentation.tracer == null || !ElasticApmInstrumentation.tracer.isRunning() || ElasticApmInstrumentation.tracer.currentTransaction() != null) {
                return;
            }
            KafkaInstrumentationHeadersHelper<ConsumerRecord, ProducerRecord> kafkaInstrumentationHelper = BaseKafkaHeadersInstrumentation.kafkaInstrHeadersHelperManager.getForClassLoaderOfClass(KafkaProducer.class);
            if (iterator != null && kafkaInstrumentationHelper != null) {
                iterator = kafkaInstrumentationHelper.wrapConsumerRecordIterator(iterator);
            }
        }
    }
}

