/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.kafka;

import co.elastic.apm.agent.bci.ElasticApmInstrumentation;
import co.elastic.apm.agent.bci.bytebuddy.CustomElementMatchers;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.kafka.BaseKafkaInstrumentation;
import co.elastic.apm.agent.kafka.helper.KafkaInstrumentationHelper;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import javax.annotation.Nullable;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;

public class KafkaProducerInstrumentation
extends BaseKafkaInstrumentation {
    public KafkaProducerInstrumentation(ElasticApmTracer tracer) {
        super(tracer);
    }

    @Override
    public ElementMatcher.Junction<ClassLoader> getClassLoaderMatcher() {
        return super.getClassLoaderMatcher().and(ElementMatchers.not(CustomElementMatchers.classLoaderCanLoadClass("org.apache.kafka.common.header.Headers")));
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("org.apache.kafka.clients.producer.KafkaProducer");
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.isPublic().and(ElementMatchers.named("send")).and(ElementMatchers.takesArgument(0, ElementMatchers.named("org.apache.kafka.clients.producer.ProducerRecord"))).and(ElementMatchers.takesArgument(1, ElementMatchers.named("org.apache.kafka.clients.producer.Callback")));
    }

    @Override
    public Class<?> getAdviceClass() {
        return KafkaProducerAdvice.class;
    }

    public static class KafkaProducerAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        @Nullable
        public static Span beforeSend(@Advice.Argument(value=0) ProducerRecord record, @Advice.Argument(value=1, readOnly=false) @Nullable Callback callback, @Advice.Local(value="helper") @Nullable KafkaInstrumentationHelper<Callback, ProducerRecord, KafkaProducer> helper) {
            if (ElasticApmInstrumentation.tracer == null) {
                return null;
            }
            Span span = null;
            helper = BaseKafkaInstrumentation.kafkaInstrHelperManager.getForClassLoaderOfClass(KafkaProducer.class);
            if (helper != null) {
                span = helper.onSendStart(record);
            }
            if (span == null) {
                return null;
            }
            callback = helper.wrapCallback(callback, span);
            return span;
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
        public static void afterSend(@Advice.Enter @Nullable Span span, @Advice.Argument(value=0) ProducerRecord record, @Advice.This KafkaProducer thiz, @Advice.Local(value="helper") @Nullable KafkaInstrumentationHelper<Callback, ProducerRecord, KafkaProducer> helper, @Advice.Thrown Throwable throwable) {
            if (helper != null && span != null) {
                helper.onSendEnd(span, record, thiz, throwable);
            }
        }
    }
}

