/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.kafka.helper;

import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.kafka.helper.KafkaInstrumentationHelperImpl;
import co.elastic.apm.agent.objectpool.Recyclable;
import javax.annotation.Nullable;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.RecordMetadata;

class CallbackWrapper
implements Callback,
Recyclable {
    private final KafkaInstrumentationHelperImpl helper;
    @Nullable
    private Callback delegate;
    private volatile Span span;

    CallbackWrapper(KafkaInstrumentationHelperImpl helper) {
        this.helper = helper;
    }

    Callback wrap(@Nullable Callback delegate, Span span) {
        this.delegate = delegate;
        this.span = span;
        return this;
    }

    public void onCompletion(RecordMetadata metadata, Exception exception) {
        try {
            this.span.activate();
            if (this.delegate != null) {
                this.delegate.onCompletion(metadata, exception);
            }
        }
        finally {
            this.span.captureException(exception);
            ((Span)this.span.deactivate()).end();
            this.helper.recycle(this);
        }
    }

    @Override
    public void resetState() {
        this.delegate = null;
        this.span = null;
    }
}

