/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.mdc;

import co.elastic.apm.agent.cache.WeakKeySoftValueLoadingCache;
import co.elastic.apm.agent.configuration.CoreConfiguration;
import co.elastic.apm.agent.impl.ActivationListener;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.transaction.TraceContext;
import co.elastic.apm.agent.impl.transaction.TraceContextHolder;
import co.elastic.apm.agent.logging.LoggingConfiguration;
import co.elastic.apm.agent.shaded.slf4j.Logger;
import co.elastic.apm.agent.shaded.slf4j.LoggerFactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import javax.annotation.Nullable;

public class MdcActivationListener
implements ActivationListener {
    private static final String SLF4J_MDC = "org!slf4j!MDC".replace('!', '.');
    private static final String LOG4J_MDC = "org.apache.log4j.MDC";
    private static final String LOG4J2_MDC = "org.apache.logging.log4j.ThreadContext";
    private static final String TRACE_ID = "trace.id";
    private static final String TRANSACTION_ID = "transaction.id";
    private static final Logger logger = LoggerFactory.getLogger(MdcActivationListener.class);
    private static final MethodHandle NOOP = MethodHandles.constant(String.class, "ClassLoader cannot load MDC/ThreadContext");
    private final WeakKeySoftValueLoadingCache<ClassLoader, MethodHandle>[] mdcPutMethodHandleCaches = new WeakKeySoftValueLoadingCache[]{new WeakKeySoftValueLoadingCache<ClassLoader, MethodHandle>(new WeakKeySoftValueLoadingCache.ValueSupplier<ClassLoader, MethodHandle>(){

        @Override
        @Nullable
        public MethodHandle get(ClassLoader classLoader) {
            try {
                return MethodHandles.lookup().findStatic(classLoader.loadClass(SLF4J_MDC), "put", MethodType.methodType(Void.TYPE, String.class, String.class));
            }
            catch (Exception e) {
                logger.debug("Class loader " + classLoader + " cannot load slf4j API", e);
                return NOOP;
            }
        }
    }), new WeakKeySoftValueLoadingCache<ClassLoader, MethodHandle>(new WeakKeySoftValueLoadingCache.ValueSupplier<ClassLoader, MethodHandle>(){

        @Override
        @Nullable
        public MethodHandle get(ClassLoader classLoader) {
            try {
                return MethodHandles.lookup().findStatic(classLoader.loadClass(MdcActivationListener.LOG4J_MDC), "put", MethodType.methodType(Void.TYPE, String.class, Object.class));
            }
            catch (Exception e) {
                logger.debug("Class loader " + classLoader + " cannot load log4j API", e);
                return NOOP;
            }
        }
    }), new WeakKeySoftValueLoadingCache<ClassLoader, MethodHandle>(new WeakKeySoftValueLoadingCache.ValueSupplier<ClassLoader, MethodHandle>(){

        @Override
        @Nullable
        public MethodHandle get(ClassLoader classLoader) {
            try {
                return MethodHandles.lookup().findStatic(classLoader.loadClass(MdcActivationListener.LOG4J2_MDC), "put", MethodType.methodType(Void.TYPE, String.class, String.class));
            }
            catch (Exception e) {
                logger.debug("Class loader " + classLoader + " cannot load log4j2 API", e);
                return NOOP;
            }
        }
    })};
    private final WeakKeySoftValueLoadingCache<ClassLoader, MethodHandle>[] mdcRemoveMethodHandleCaches = new WeakKeySoftValueLoadingCache[]{new WeakKeySoftValueLoadingCache<ClassLoader, MethodHandle>(new WeakKeySoftValueLoadingCache.ValueSupplier<ClassLoader, MethodHandle>(){

        @Override
        @Nullable
        public MethodHandle get(ClassLoader classLoader) {
            try {
                return MethodHandles.lookup().findStatic(classLoader.loadClass(SLF4J_MDC), "remove", MethodType.methodType(Void.TYPE, String.class));
            }
            catch (Exception ignore) {
                return NOOP;
            }
        }
    }), new WeakKeySoftValueLoadingCache<ClassLoader, MethodHandle>(new WeakKeySoftValueLoadingCache.ValueSupplier<ClassLoader, MethodHandle>(){

        @Override
        @Nullable
        public MethodHandle get(ClassLoader classLoader) {
            try {
                return MethodHandles.lookup().findStatic(classLoader.loadClass(MdcActivationListener.LOG4J_MDC), "remove", MethodType.methodType(Void.TYPE, String.class));
            }
            catch (Exception ignore) {
                return NOOP;
            }
        }
    }), new WeakKeySoftValueLoadingCache<ClassLoader, MethodHandle>(new WeakKeySoftValueLoadingCache.ValueSupplier<ClassLoader, MethodHandle>(){

        @Override
        @Nullable
        public MethodHandle get(ClassLoader classLoader) {
            try {
                return MethodHandles.lookup().findStatic(classLoader.loadClass(MdcActivationListener.LOG4J2_MDC), "remove", MethodType.methodType(Void.TYPE, String.class));
            }
            catch (Exception ignore) {
                return NOOP;
            }
        }
    })};
    private final LoggingConfiguration loggingConfiguration;
    private final CoreConfiguration coreConfiguration;
    private final ElasticApmTracer tracer;

    public MdcActivationListener(ElasticApmTracer tracer) {
        this.tracer = tracer;
        this.loggingConfiguration = tracer.getConfig(LoggingConfiguration.class);
        this.coreConfiguration = tracer.getConfig(CoreConfiguration.class);
    }

    @Override
    public void beforeActivate(TraceContextHolder<?> context) throws Throwable {
        if (this.loggingConfiguration.isLogCorrelationEnabled() && this.tracer.isRunning()) {
            for (WeakKeySoftValueLoadingCache<ClassLoader, MethodHandle> mdcPutMethodHandleCache : this.mdcPutMethodHandleCaches) {
                MethodHandle put = mdcPutMethodHandleCache.get(this.getApplicationClassLoader(context));
                if (put == null || put == NOOP) continue;
                TraceContext traceContext = context.getTraceContext();
                if (this.tracer.getActive() != null) continue;
                put.invoke(TRACE_ID, traceContext.getTraceId().toString());
                put.invoke(TRANSACTION_ID, traceContext.getTransactionId().toString());
            }
        }
    }

    @Override
    public void afterDeactivate(TraceContextHolder<?> deactivatedContext) throws Throwable {
        if (this.loggingConfiguration.isLogCorrelationEnabled()) {
            for (WeakKeySoftValueLoadingCache<ClassLoader, MethodHandle> mdcRemoveMethodHandleCache : this.mdcRemoveMethodHandleCaches) {
                MethodHandle remove = mdcRemoveMethodHandleCache.get(this.getApplicationClassLoader(deactivatedContext));
                if (remove == null || remove == NOOP || this.tracer.getActive() != null) continue;
                remove.invokeExact(TRACE_ID);
                remove.invokeExact(TRANSACTION_ID);
            }
        }
    }

    private ClassLoader getApplicationClassLoader(TraceContextHolder<?> context) {
        ClassLoader applicationClassLoader = context.getTraceContext().getApplicationClassLoader();
        if (applicationClassLoader != null) {
            return applicationClassLoader;
        }
        return this.getFallbackClassLoader();
    }

    private ClassLoader getFallbackClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        return classLoader;
    }
}

