/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.metrics.builtin;

import co.elastic.apm.agent.context.AbstractLifecycleListener;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.matcher.WildcardMatcher;
import co.elastic.apm.agent.metrics.DoubleSupplier;
import co.elastic.apm.agent.metrics.Labels;
import co.elastic.apm.agent.metrics.MetricRegistry;
import co.elastic.apm.agent.util.JmxUtils;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;

public class SystemMetrics
extends AbstractLifecycleListener {
    private final OperatingSystemMXBean operatingSystemBean = ManagementFactory.getOperatingSystemMXBean();
    @Nullable
    private final Method systemCpuUsage = JmxUtils.getOperatingSystemMBeanMethod(this.operatingSystemBean, "getSystemCpuLoad");
    @Nullable
    private final Method processCpuUsage = JmxUtils.getOperatingSystemMBeanMethod(this.operatingSystemBean, "getProcessCpuLoad");
    @Nullable
    private final Method freeMemory = JmxUtils.getOperatingSystemMBeanMethod(this.operatingSystemBean, "getFreePhysicalMemorySize");
    @Nullable
    private final Method totalMemory = JmxUtils.getOperatingSystemMBeanMethod(this.operatingSystemBean, "getTotalPhysicalMemorySize");
    @Nullable
    private final Method virtualProcessMemory = JmxUtils.getOperatingSystemMBeanMethod(this.operatingSystemBean, "getCommittedVirtualMemorySize");
    private final File memInfoFile;

    public SystemMetrics() {
        this(new File("/proc/meminfo"));
    }

    SystemMetrics(File memInfoFile) {
        this.memInfoFile = memInfoFile;
    }

    @Override
    public void start(ElasticApmTracer tracer) {
        this.bindTo(tracer.getMetricRegistry());
    }

    void bindTo(MetricRegistry metricRegistry) {
        metricRegistry.addUnlessNegative("system.cpu.total.norm.pct", Labels.EMPTY, new DoubleSupplier(){

            @Override
            public double get() {
                return SystemMetrics.this.invoke(SystemMetrics.this.systemCpuUsage);
            }
        });
        metricRegistry.addUnlessNegative("system.process.cpu.total.norm.pct", Labels.EMPTY, new DoubleSupplier(){

            @Override
            public double get() {
                return SystemMetrics.this.invoke(SystemMetrics.this.processCpuUsage);
            }
        });
        metricRegistry.addUnlessNan("system.memory.total", Labels.EMPTY, new DoubleSupplier(){

            @Override
            public double get() {
                return SystemMetrics.this.invoke(SystemMetrics.this.totalMemory);
            }
        });
        if (this.memInfoFile.canRead()) {
            metricRegistry.addUnlessNan("system.memory.actual.free", Labels.EMPTY, new DoubleSupplier(){
                final List<WildcardMatcher> relevantLines = Arrays.asList(WildcardMatcher.caseSensitiveMatcher("MemAvailable:*kB"), WildcardMatcher.caseSensitiveMatcher("MemFree:*kB"), WildcardMatcher.caseSensitiveMatcher("Buffers:*kB"), WildcardMatcher.caseSensitiveMatcher("Cached:*kB"));

                /*
                 * Exception decompiling
                 */
                @Override
                public double get() {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }
            });
        } else {
            metricRegistry.addUnlessNan("system.memory.actual.free", Labels.EMPTY, new DoubleSupplier(){

                @Override
                public double get() {
                    return SystemMetrics.this.invoke(SystemMetrics.this.freeMemory);
                }
            });
        }
        metricRegistry.addUnlessNegative("system.process.memory.size", Labels.EMPTY, new DoubleSupplier(){

            @Override
            public double get() {
                return SystemMetrics.this.invoke(SystemMetrics.this.virtualProcessMemory);
            }
        });
    }

    private double invoke(@Nullable Method method) {
        try {
            return method != null ? ((Number)method.invoke((Object)this.operatingSystemBean, new Object[0])).doubleValue() : Double.NaN;
        }
        catch (Throwable e) {
            return Double.NaN;
        }
    }

    static /* synthetic */ File access$400(SystemMetrics x0) {
        return x0.memInfoFile;
    }
}

