/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.mongoclient;

import co.elastic.apm.agent.bci.ElasticApmInstrumentation;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.slf4j.Logger;
import co.elastic.apm.agent.shaded.slf4j.LoggerFactory;
import com.mongodb.MongoNamespace;
import com.mongodb.ServerAddress;
import com.mongodb.connection.Connection;
import javax.annotation.Nullable;
import org.bson.BsonDocument;
import org.bson.BsonValue;

public class ConnectionAdvice {
    public static final Logger logger = LoggerFactory.getLogger(ConnectionAdvice.class);

    @Nullable
    @Advice.OnMethodEnter(suppress=Throwable.class)
    public static Span onEnter(@Advice.This Connection thiz, @Advice.Argument(value=0) Object databaseOrMongoNamespace, @Advice.Argument(value=1) BsonDocument command) {
        Span span = ElasticApmInstrumentation.createExitSpan();
        if (span == null) {
            return null;
        }
        String database = "";
        String collection = null;
        if (databaseOrMongoNamespace instanceof String) {
            database = (String)databaseOrMongoNamespace;
        } else if (databaseOrMongoNamespace instanceof MongoNamespace) {
            MongoNamespace namespace = (MongoNamespace)databaseOrMongoNamespace;
            database = namespace.getDatabaseName();
            collection = namespace.getCollectionName();
        }
        ((Span)span.withType("db").withSubtype("mongodb").appendToName(database)).getContext().getDb().withType("mongodb");
        span.getContext().getDestination().getService().withName("mongodb").withResource("mongodb").withType("db");
        ServerAddress serverAddress = thiz.getDescription().getServerAddress();
        span.getContext().getDestination().withAddress(serverAddress.getHost()).withPort(serverAddress.getPort());
        try {
            BsonValue collectionName;
            String cmd;
            String string = command.containsKey((Object)"find") ? "find" : (command.containsKey((Object)"insert") ? "insert" : (command.containsKey((Object)"count") ? "count" : (command.containsKey((Object)"drop") ? "drop" : (command.containsKey((Object)"update") ? "update" : (command.containsKey((Object)"delete") ? "delete" : (command.containsKey((Object)"create") ? "create" : (cmd = command.containsKey((Object)"getMore") ? "getMore" : (String)command.keySet().iterator().next())))))));
            if (collection == null && (collectionName = command.get((Object)cmd)) != null && collectionName.isString()) {
                collection = collectionName.asString().getValue();
                ((Span)span.appendToName(".")).appendToName(collection);
            }
            if (collection == null && (collectionName = command.get((Object)"collection")) != null && collectionName.isString()) {
                collection = collectionName.asString().getValue();
                ((Span)span.appendToName(".")).appendToName(collection);
            }
            ((Span)((Span)span.appendToName(".")).appendToName(cmd)).withAction(cmd);
        }
        catch (RuntimeException e) {
            logger.error("Exception while determining MongoDB command and collection", e);
        }
        span.activate();
        return span;
    }

    @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class)
    public static void onExit(@Nullable @Advice.Enter Span span, @Advice.Thrown Throwable thrown, @Advice.Origin(value="#m") String methodName) {
        if (span != null) {
            ((Span)span.deactivate()).captureException(thrown);
            if (!methodName.endsWith("Async")) {
                span.end();
            }
        }
    }
}

