/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.plugin.api;

import co.elastic.apm.agent.plugin.api.ApiInstrumentation;
import co.elastic.apm.agent.plugin.api.HeaderExtractorBridge;
import co.elastic.apm.agent.plugin.api.HeadersExtractorBridge;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import java.lang.invoke.MethodHandle;
import javax.annotation.Nullable;

public class ElasticApmApiInstrumentation
extends ApiInstrumentation {
    static final String PUBLIC_API_INSTRUMENTATION_GROUP = "public-api";
    private final ElementMatcher<? super MethodDescription> methodMatcher;

    ElasticApmApiInstrumentation(ElementMatcher<? super MethodDescription> methodMatcher) {
        this.methodMatcher = methodMatcher;
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("co.elastic.apm.api.ElasticApm");
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return this.methodMatcher;
    }

    public static class CaptureExceptionInstrumentation
    extends ElasticApmApiInstrumentation {
        public CaptureExceptionInstrumentation() {
            super(ElementMatchers.named("captureException"));
        }

        @Advice.OnMethodEnter(suppress=Throwable.class)
        private static void captureException(@Advice.Origin Class<?> clazz, @Advice.Argument(value=0) @Nullable Throwable e) {
            if (tracer != null) {
                tracer.captureException(e, clazz.getClassLoader());
            }
        }
    }

    public static class CurrentSpanInstrumentation
    extends ElasticApmApiInstrumentation {
        public CurrentSpanInstrumentation() {
            super(ElementMatchers.named("doGetCurrentSpan"));
        }

        @Advice.OnMethodExit(suppress=Throwable.class)
        private static void doGetCurrentSpan(@Advice.Return(readOnly=false) Object span) {
            if (tracer != null) {
                span = tracer.getActive();
            }
        }
    }

    public static class CurrentTransactionInstrumentation
    extends ElasticApmApiInstrumentation {
        public CurrentTransactionInstrumentation() {
            super(ElementMatchers.named("doGetCurrentTransaction"));
        }

        @Advice.OnMethodExit(suppress=Throwable.class)
        private static void doGetCurrentTransaction(@Advice.Return(readOnly=false) Object transaction) {
            if (tracer != null) {
                transaction = tracer.currentTransaction();
            }
        }
    }

    public static class StartTransactionWithRemoteParentInstrumentation
    extends ElasticApmApiInstrumentation {
        public StartTransactionWithRemoteParentInstrumentation() {
            super(ElementMatchers.named("doStartTransactionWithRemoteParentFunction"));
        }

        @Advice.OnMethodExit(suppress=Throwable.class)
        private static void doStartTransaction(@Advice.Origin Class<?> clazz, @Advice.Return(readOnly=false) Object transaction, @Advice.Argument(value=0) MethodHandle getFirstHeader, @Advice.Argument(value=1) @Nullable Object headerExtractor, @Advice.Argument(value=2) MethodHandle getAllHeaders, @Advice.Argument(value=3) @Nullable Object headersExtractor) {
            if (tracer != null) {
                if (headersExtractor != null) {
                    HeadersExtractorBridge headersExtractorBridge = HeadersExtractorBridge.get(getFirstHeader, getAllHeaders);
                    transaction = tracer.startChildTransaction(HeadersExtractorBridge.Extractor.of(headerExtractor, headersExtractor), headersExtractorBridge, clazz.getClassLoader());
                } else if (headerExtractor != null) {
                    HeaderExtractorBridge headersExtractorBridge = HeaderExtractorBridge.get(getFirstHeader);
                    transaction = tracer.startChildTransaction(headerExtractor, headersExtractorBridge, clazz.getClassLoader());
                } else {
                    transaction = tracer.startRootTransaction(clazz.getClassLoader());
                }
            }
        }
    }

    public static class StartTransactionInstrumentation
    extends ElasticApmApiInstrumentation {
        public StartTransactionInstrumentation() {
            super(ElementMatchers.named("doStartTransaction"));
        }

        @Advice.OnMethodExit(suppress=Throwable.class)
        private static void doStartTransaction(@Advice.Origin Class<?> clazz, @Advice.Return(readOnly=false) Object transaction) {
            if (tracer != null) {
                transaction = tracer.startRootTransaction(clazz.getClassLoader());
            }
        }
    }
}

