/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.plugin.api;

import co.elastic.apm.agent.impl.transaction.TraceContext;
import co.elastic.apm.agent.impl.transaction.TraceContextHolder;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.plugin.api.ApiInstrumentation;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.agent.shaded.bytebuddy.implementation.bytecode.assign.Assigner;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import javax.annotation.Nullable;

public class TransactionInstrumentation
extends ApiInstrumentation {
    private final ElementMatcher<? super MethodDescription> methodMatcher;

    public TransactionInstrumentation(ElementMatcher<? super MethodDescription> methodMatcher) {
        this.methodMatcher = methodMatcher;
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("co.elastic.apm.api.TransactionImpl");
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return this.methodMatcher;
    }

    public static class AddCustomContextInstrumentation
    extends TransactionInstrumentation {
        public AddCustomContextInstrumentation() {
            super(ElementMatchers.named("addCustomContext"));
        }

        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static void addCustomContext(@Advice.FieldValue(value="span", typing=Assigner.Typing.DYNAMIC) TraceContextHolder<?> context, @Advice.Argument(value=0) String key, @Nullable @Advice.Argument(value=1) Object value) {
            if (value != null && context instanceof Transaction) {
                if (value instanceof String) {
                    ((Transaction)context).addCustomContext(key, (String)value);
                } else if (value instanceof Number) {
                    ((Transaction)context).addCustomContext(key, (Number)value);
                } else if (value instanceof Boolean) {
                    ((Transaction)context).addCustomContext(key, (Boolean)value);
                }
            }
        }
    }

    public static class SetResultInstrumentation
    extends TransactionInstrumentation {
        public SetResultInstrumentation() {
            super(ElementMatchers.named("setResult"));
        }

        @Advice.OnMethodEnter(suppress=Throwable.class)
        private static void ensureParentId(@Advice.FieldValue(value="span", typing=Assigner.Typing.DYNAMIC) Transaction transaction, @Advice.Argument(value=0) String result) {
            transaction.withResult(result);
        }
    }

    public static class EnsureParentIdInstrumentation
    extends TransactionInstrumentation {
        public EnsureParentIdInstrumentation() {
            super(ElementMatchers.named("ensureParentId"));
        }

        @Advice.OnMethodExit(suppress=Throwable.class)
        public static void ensureParentId(@Advice.FieldValue(value="span", typing=Assigner.Typing.DYNAMIC) Transaction transaction, @Advice.Return(readOnly=false) String spanId) {
            if (tracer != null) {
                TraceContext traceContext = transaction.getTraceContext();
                if (traceContext.getParentId().isEmpty()) {
                    traceContext.getParentId().setToRandomValue();
                }
                spanId = traceContext.getParentId().toString();
            }
        }
    }

    public static class SetUserInstrumentation
    extends TransactionInstrumentation {
        public SetUserInstrumentation() {
            super(ElementMatchers.named("setUser"));
        }

        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static void setUser(@Advice.FieldValue(value="span", typing=Assigner.Typing.DYNAMIC) Transaction transaction, @Advice.Argument(value=0) String id, @Advice.Argument(value=1) String email, @Advice.Argument(value=2) String username) {
            transaction.setUser(id, email, username);
        }
    }
}

