/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.profiler;

import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.StackFrame;
import co.elastic.apm.agent.impl.transaction.TraceContext;
import co.elastic.apm.agent.objectpool.ObjectPool;
import co.elastic.apm.agent.objectpool.Recyclable;
import co.elastic.apm.agent.shaded.slf4j.Logger;
import co.elastic.apm.agent.shaded.slf4j.LoggerFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public class CallTree
implements Recyclable {
    private static final int INITIAL_CHILD_SIZE = 2;
    @Nullable
    private CallTree parent;
    protected int count;
    private List<CallTree> children = new ArrayList<CallTree>(2);
    @Nullable
    private StackFrame frame;
    protected long start;
    private long lastSeen;
    private boolean ended;
    private long activationTimestamp = -1L;
    @Nullable
    private TraceContext activeContextOfDirectParent;
    private long deactivationTimestamp = -1L;
    private boolean isSpan;

    public void set(@Nullable CallTree parent, StackFrame frame, long nanoTime) {
        this.parent = parent;
        this.frame = frame;
        this.start = nanoTime;
    }

    public void activation(TraceContext traceContext, long activationTimestamp) {
        this.activeContextOfDirectParent = traceContext;
        this.activationTimestamp = activationTimestamp;
    }

    protected void handleDeactivation(TraceContext deactivatedSpan, long activationTimestamp, long deactivationTimestamp) {
        if (deactivatedSpan.equals(this.activeContextOfDirectParent)) {
            this.deactivationTimestamp = deactivationTimestamp;
        } else {
            CallTree lastChild = this.getLastChild();
            if (lastChild != null) {
                lastChild.handleDeactivation(deactivatedSpan, activationTimestamp, deactivationTimestamp);
            }
        }
        if (this.happenedDuring(activationTimestamp) && this.happenedAfter(deactivationTimestamp)) {
            this.lastSeen = deactivationTimestamp;
        }
    }

    private boolean happenedDuring(long timestamp) {
        return this.start <= timestamp && timestamp <= this.lastSeen;
    }

    private boolean happenedAfter(long timestamp) {
        return this.lastSeen < timestamp;
    }

    public static Root createRoot(ObjectPool<Root> rootPool, byte[] traceContext, @Nullable String serviceName, long nanoTime) {
        Root root = rootPool.createInstance();
        root.set(traceContext, serviceName, nanoTime);
        return root;
    }

    protected void addFrame(List<StackFrame> stackFrames, int index, @Nullable TraceContext activeSpan, long activationTimestamp, long nanoTime, ObjectPool<CallTree> callTreePool, long minDurationNs) {
        ++this.count;
        this.lastSeen = nanoTime;
        if (Objects.equals(this.activeContextOfDirectParent, activeSpan)) {
            activeSpan = null;
        }
        CallTree lastChild = this.getLastChild();
        boolean endChild = true;
        if (index >= 1) {
            StackFrame frame = stackFrames.get(--index);
            if (lastChild != null) {
                if (!lastChild.isEnded() && frame.equals(lastChild.frame)) {
                    lastChild.addFrame(stackFrames, index, activeSpan, activationTimestamp, nanoTime, callTreePool, minDurationNs);
                    endChild = false;
                } else {
                    this.addChild(frame, stackFrames, index, activeSpan, activationTimestamp, nanoTime, callTreePool, minDurationNs);
                }
            } else {
                this.addChild(frame, stackFrames, index, activeSpan, activationTimestamp, nanoTime, callTreePool, minDurationNs);
            }
        }
        if (lastChild != null && !lastChild.isEnded() && endChild) {
            lastChild.end(callTreePool, minDurationNs);
        }
    }

    private void addChild(StackFrame frame, List<StackFrame> stackFrames, int index, @Nullable TraceContext traceContext, long activationTimestamp, long nanoTime, ObjectPool<CallTree> callTreePool, long minDurationNs) {
        CallTree callTree = callTreePool.createInstance();
        callTree.set(this, frame, nanoTime);
        if (traceContext != null) {
            callTree.activation(traceContext, activationTimestamp);
        }
        this.children.add(callTree);
        callTree.addFrame(stackFrames, index, null, activationTimestamp, nanoTime, callTreePool, minDurationNs);
    }

    long getDurationUs() {
        return this.getDurationNs() / 1000L;
    }

    private long getDurationNs() {
        return this.lastSeen - this.start;
    }

    public int getCount() {
        return this.count;
    }

    @Nullable
    public StackFrame getFrame() {
        return this.frame;
    }

    public List<CallTree> getChildren() {
        return this.children;
    }

    void end(ObjectPool<CallTree> pool, long minDurationNs) {
        this.ended = true;
        if (this.deactivationHappenedBeforeEnd()) {
            this.start = Math.min(this.activationTimestamp, this.start);
            List<CallTree> callTrees = this.getChildren();
            int size = callTrees.size();
            for (int i = 0; i < size; ++i) {
                CallTree child = callTrees.get(i);
                child.activation(this.activeContextOfDirectParent, this.activationTimestamp);
                child.deactivationTimestamp = this.deactivationTimestamp;
                child.end(pool, minDurationNs);
            }
            this.activeContextOfDirectParent = null;
            this.activationTimestamp = -1L;
            this.deactivationTimestamp = -1L;
        }
        if (this.parent != null && (this.count == 1 || this.isFasterThan(minDurationNs))) {
            this.parent.children.remove(this);
            this.recycle(pool);
        } else {
            CallTree lastChild = this.getLastChild();
            if (lastChild != null && !lastChild.isEnded()) {
                lastChild.end(pool, minDurationNs);
            }
        }
    }

    private boolean isFasterThan(long minDurationNs) {
        return this.getDurationNs() < minDurationNs;
    }

    private boolean deactivationHappenedBeforeEnd() {
        return this.activeContextOfDirectParent != null && this.deactivationTimestamp > -1L && this.lastSeen > this.deactivationTimestamp;
    }

    public boolean isLeaf() {
        return this.children.isEmpty();
    }

    private boolean isPillar() {
        return this.children.size() == 1 && this.children.get((int)0).count == this.count;
    }

    @Nullable
    public CallTree getLastChild() {
        return this.children.size() > 0 ? this.children.get(this.children.size() - 1) : null;
    }

    public boolean isEnded() {
        return this.ended;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        try {
            this.toString(sb);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return sb.toString();
    }

    private void toString(Appendable out) throws IOException {
        this.toString(out, 0);
    }

    private void toString(Appendable out, int level) throws IOException {
        for (int i = 0; i < level; ++i) {
            out.append("  ");
        }
        out.append(this.frame != null ? this.frame.getClassName() : "null").append('.').append(this.frame != null ? this.frame.getMethodName() : "null").append(' ').append(Integer.toString(this.count)).append('\n');
        for (CallTree node : this.children) {
            node.toString(out, level + 1);
        }
    }

    int spanify(Root root, TraceContext parentContext) {
        int createdSpans = 0;
        if (this.activeContextOfDirectParent != null) {
            parentContext = this.activeContextOfDirectParent;
        }
        Span span = null;
        if (!this.isPillar() || this.isLeaf()) {
            ++createdSpans;
            span = this.asSpan(root, parentContext);
            this.isSpan = true;
        }
        List<CallTree> children = this.getChildren();
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            createdSpans += children.get(i).spanify(root, span != null ? span.getTraceContext() : parentContext);
        }
        if (span != null) {
            span.end(span.getTimestamp() + this.getDurationUs());
        }
        return createdSpans;
    }

    protected Span asSpan(Root root, TraceContext parentContext) {
        Span span = parentContext.createSpan(root.getEpochMicros(this.start)).withType("app").withSubtype("inferred");
        this.frame.appendSimpleClassName(span.getNameForSerialization());
        span.appendToName("#");
        span.appendToName(this.frame.getMethodName());
        if (!root.rootContext.equals(parentContext)) {
            assert (this.parent != null);
            ArrayList<StackFrame> stackTrace = new ArrayList<StackFrame>();
            this.parent.fillStackTrace(stackTrace);
            span.setStackTrace(stackTrace);
        } else {
            span.setStackTrace(Collections.emptyList());
        }
        return span;
    }

    private void fillStackTrace(List<StackFrame> stackTrace) {
        if (this.parent != null && !this.isSpan) {
            stackTrace.add(this.frame);
            this.parent.fillStackTrace(stackTrace);
        }
    }

    public void recycle(ObjectPool<CallTree> pool) {
        List<CallTree> children = this.children;
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            children.get(i).recycle(pool);
        }
        pool.recycle(this);
    }

    @Override
    public void resetState() {
        this.parent = null;
        this.count = 0;
        this.frame = null;
        this.start = 0L;
        this.lastSeen = 0L;
        this.ended = false;
        this.activationTimestamp = -1L;
        this.activeContextOfDirectParent = null;
        this.deactivationTimestamp = -1L;
        this.isSpan = false;
        if (this.children.size() > 2) {
            this.children = new ArrayList<CallTree>(2);
        } else {
            this.children.clear();
        }
    }

    public static class Root
    extends CallTree
    implements Recyclable {
        private static final Logger logger = LoggerFactory.getLogger(Root.class);
        private static final StackFrame ROOT_FRAME = new StackFrame("root", "root");
        protected TraceContext rootContext;
        @Nullable
        private TraceContext activeSpan;
        private long activationTimestamp = -1L;
        private byte[] activeSpanSerialized = new byte[42];

        public Root(ElasticApmTracer tracer) {
            this.rootContext = TraceContext.with64BitId(tracer);
        }

        private void set(byte[] traceContext, @Nullable String serviceName, long nanoTime) {
            super.set(null, ROOT_FRAME, nanoTime);
            this.rootContext.deserialize(traceContext, serviceName);
            this.setActiveSpan(traceContext, nanoTime);
        }

        public void setActiveSpan(byte[] activeSpanSerialized, long timestamp) {
            this.activationTimestamp = timestamp;
            System.arraycopy(activeSpanSerialized, 0, this.activeSpanSerialized, 0, activeSpanSerialized.length);
            this.activeSpan = null;
        }

        public void onActivation(byte[] active, long timestamp) {
            this.setActiveSpan(active, timestamp);
        }

        public void onDeactivation(byte[] deactivated, byte[] active, long timestamp) {
            if (logger.isDebugEnabled() && !Arrays.equals(this.activeSpanSerialized, deactivated)) {
                logger.warn("Illegal state: deactivating span that is not active");
            }
            if (this.activeSpan != null) {
                this.handleDeactivation(this.activeSpan, this.activationTimestamp, timestamp);
            }
            this.setActiveSpan(active, timestamp);
        }

        public void addStackTrace(ElasticApmTracer tracer, List<StackFrame> stackTrace, long nanoTime, ObjectPool<CallTree> callTreePool, long minDurationNs) {
            if (this.activeSpan == null) {
                this.activeSpan = TraceContext.with64BitId(tracer);
                this.activeSpan.deserialize(this.activeSpanSerialized, this.rootContext.getServiceName());
            }
            this.addFrame(stackTrace, stackTrace.size(), this.activeSpan, this.activationTimestamp, nanoTime, callTreePool, minDurationNs);
        }

        public int spanify() {
            int createdSpans = 0;
            List<CallTree> callTrees = this.getChildren();
            int size = callTrees.size();
            for (int i = 0; i < size; ++i) {
                createdSpans += callTrees.get(i).spanify(this, this.rootContext);
            }
            return createdSpans;
        }

        public TraceContext getRootContext() {
            return this.rootContext;
        }

        public long getEpochMicros(long nanoTime) {
            return this.rootContext.getClock().getEpochMicros(nanoTime);
        }

        @Override
        public void recycle(ObjectPool<CallTree> pool) {
            List<CallTree> children = this.getChildren();
            int size = children.size();
            for (int i = 0; i < size; ++i) {
                children.get(i).recycle(pool);
            }
        }

        @Override
        public void resetState() {
            super.resetState();
            this.activeSpan = null;
            this.activationTimestamp = -1L;
        }
    }
}

