/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.profiler;

import co.elastic.apm.agent.impl.ActivationListener;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.transaction.TraceContextHolder;
import co.elastic.apm.agent.profiler.SamplingProfiler;
import java.util.Objects;

public class ProfilingActivationListener
implements ActivationListener {
    private final ElasticApmTracer tracer;
    private final SamplingProfiler profiler;

    public ProfilingActivationListener(ElasticApmTracer tracer) {
        this(tracer, Objects.requireNonNull(tracer.getLifecycleListener(SamplingProfiler.class)));
    }

    ProfilingActivationListener(ElasticApmTracer tracer, SamplingProfiler profiler) {
        this.tracer = tracer;
        this.profiler = profiler;
    }

    @Override
    public void beforeActivate(TraceContextHolder<?> context) throws Throwable {
        if (!context.isSampled()) {
            return;
        }
        this.profiler.onActivation(context, this.tracer.getActive());
    }

    @Override
    public void afterDeactivate(TraceContextHolder<?> deactivatedContext) throws Throwable {
        if (!deactivatedContext.isSampled()) {
            return;
        }
        this.profiler.onDeactivation(deactivatedContext, this.tracer.getActive());
    }
}

