/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.profiler;

public class ThreadMatcher {
    private final ThreadGroup systemThreadGroup;
    private Thread[] threads = new Thread[16];

    public ThreadMatcher() {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        while (threadGroup.getParent() != null) {
            threadGroup = threadGroup.getParent();
        }
        this.systemThreadGroup = threadGroup;
    }

    public <S1, S2> void forEachThread(NonCapturingPredicate<Thread, S1> predicate, S1 state1, NonCapturingConsumer<Thread, S2> consumer, S2 state2) {
        int count = this.systemThreadGroup.activeCount();
        do {
            int expectedArrayLength;
            if (this.threads.length >= (expectedArrayLength = count + count / 2 + 1)) continue;
            this.threads = new Thread[expectedArrayLength];
        } while ((count = this.systemThreadGroup.enumerate(this.threads, true)) >= this.threads.length);
        for (int i = 0; i < count; ++i) {
            Thread thread = this.threads[i];
            if (predicate.test(thread, state1)) {
                consumer.accept(thread, state2);
            }
            this.threads[i] = null;
        }
    }

    static interface NonCapturingConsumer<T, S> {
        public void accept(T var1, S var2);
    }

    static interface NonCapturingPredicate<T, S> {
        public boolean test(T var1, S var2);
    }
}

