/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.profiler.asyncprofiler;

import co.elastic.apm.agent.util.IOUtils;
import java.io.File;
import java.io.IOException;
import javax.annotation.Nullable;

public class AsyncProfiler {
    @Nullable
    private static volatile AsyncProfiler instance;

    private AsyncProfiler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AsyncProfiler getInstance() {
        AsyncProfiler result = instance;
        if (result != null) {
            return result;
        }
        Class<AsyncProfiler> clazz = AsyncProfiler.class;
        synchronized (AsyncProfiler.class) {
            if (instance == null) {
                AsyncProfiler.loadNativeLibrary();
                instance = new AsyncProfiler();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    private static void loadNativeLibrary() {
        String libraryName = AsyncProfiler.getLibraryFileName();
        File file = IOUtils.exportResourceToTemp("asyncprofiler/" + libraryName + ".so", libraryName, ".so");
        System.load(file.getAbsolutePath());
    }

    private static String getLibraryFileName() {
        String os = System.getProperty("os.name").toLowerCase();
        String arch = System.getProperty("os.arch").toLowerCase();
        if (os.contains("linux")) {
            if (arch.contains("arm") || arch.contains("aarch")) {
                return "libasyncProfiler-linux-arm";
            }
            if (arch.contains("64")) {
                return "libasyncProfiler-linux-x64";
            }
            if (arch.contains("86")) {
                return "libasyncProfiler-linux-x86";
            }
            throw new IllegalStateException("Async-profiler does not work on Linux " + arch);
        }
        if (os.contains("mac")) {
            return "libasyncProfiler-macos";
        }
        throw new IllegalStateException("Async-profiler does not work on " + os);
    }

    public void stop() throws IllegalStateException {
        this.stop0();
    }

    public String execute(String command) throws IllegalArgumentException, IOException {
        return this.execute0(command);
    }

    public void enableProfilingThread(Thread thread) throws IllegalStateException {
        this.filterThread(thread, true);
    }

    public void disableProfilingThread(Thread thread) throws IllegalStateException {
        this.filterThread(thread, false);
    }

    public void enableProfilingCurrentThread() {
        this.filterThread0(null, true);
    }

    public void disableProfilingCurrentThread() throws IllegalStateException {
        this.filterThread0(null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void filterThread(Thread thread, boolean enable) throws IllegalStateException {
        Thread thread2 = thread;
        synchronized (thread2) {
            Thread.State state = thread.getState();
            if (state == Thread.State.NEW || state == Thread.State.TERMINATED) {
                return;
            }
            this.filterThread0(thread, enable);
        }
    }

    private native long getSamples();

    private native void start0(String var1, long var2, boolean var4) throws IllegalStateException;

    private native void stop0() throws IllegalStateException;

    private native String execute0(String var1) throws IllegalArgumentException, IOException;

    private native void filterThread0(Thread var1, boolean var2);
}

