/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.profiler.collections;

public class CollectionUtil {
    public static void validateLoadFactor(float loadFactor) {
        if (loadFactor < 0.1f || loadFactor > 0.9f) {
            throw new IllegalArgumentException("load factor must be in the range of 0.1 to 0.9: " + loadFactor);
        }
    }

    public static int findNextPositivePowerOfTwo(int value) {
        return 1 << 32 - Integer.numberOfLeadingZeros(value - 1);
    }

    public static long findNextPositivePowerOfTwo(long value) {
        return 1L << 64 - Long.numberOfLeadingZeros(value - 1L);
    }
}

