/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.redis.lettuce;

import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.redis.lettuce.Lettuce34Instrumentation;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.NamedElement;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import co.elastic.apm.agent.shaded.slf4j.Logger;
import co.elastic.apm.agent.shaded.slf4j.LoggerFactory;
import com.lambdaworks.redis.protocol.RedisCommand;
import java.util.Arrays;
import java.util.Collection;

public abstract class Lettuce34StopSpanInstrumentation
extends Lettuce34Instrumentation {
    public static final Logger logger = LoggerFactory.getLogger(Lettuce34StopSpanInstrumentation.class);

    @Override
    public ElementMatcher<? super NamedElement> getTypeMatcherPreFilter() {
        return ElementMatchers.nameStartsWith("com.lambdaworks.redis").and(ElementMatchers.nameContains("Command"));
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.hasSuperType(ElementMatchers.named("com.lambdaworks.redis.protocol.RedisCommand")).and(ElementMatchers.declaresMethod(ElementMatchers.named("getType")));
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Arrays.asList("redis", "lettuce");
    }

    public static class OnCancel
    extends Lettuce34StopSpanInstrumentation {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        private static void beforeComplete(@Advice.This RedisCommand command) {
            Span span = (Span)commandToSpan.remove(command);
            if (span != null) {
                logger.debug("Command#cancel");
                span.end();
            }
        }

        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("cancel").and(ElementMatchers.takesArguments(0));
        }
    }

    public static class OnCompleteExceptionally
    extends Lettuce34StopSpanInstrumentation {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        private static void beforeComplete(@Advice.This RedisCommand command, @Advice.Argument(value=0) Throwable throwable) {
            Span span = (Span)commandToSpan.remove(command);
            if (span != null) {
                logger.debug("Command#completeExceptionally");
                ((Span)span.captureException(throwable)).end();
            }
        }

        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("completeExceptionally").and(ElementMatchers.takesArguments(Throwable.class));
        }
    }

    public static class OnComplete
    extends Lettuce34StopSpanInstrumentation {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        private static void beforeComplete(@Advice.This RedisCommand command) {
            Span span = (Span)commandToSpan.remove(command);
            if (span != null) {
                logger.debug("Command#complete");
                span.end();
            }
        }

        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("complete").and(ElementMatchers.takesArguments(0));
        }
    }
}

