/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.redis.redisson;

import co.elastic.apm.agent.bci.ElasticApmInstrumentation;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.redis.RedisSpanUtils;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import io.netty.channel.Channel;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.redisson.client.RedisConnection;
import org.redisson.client.protocol.CommandData;
import org.redisson.client.protocol.CommandsData;

public class RedisConnectionInstrumentation
extends ElasticApmInstrumentation {
    @Advice.OnMethodEnter
    private static void beforeSend(@Advice.This RedisConnection connection, @Advice.Argument(value=0) Object args, @Nullable @Advice.Local(value="span") Span span) {
        span = RedisSpanUtils.createRedisSpan("");
        if (span != null) {
            if (args instanceof CommandsData) {
                List commands = ((CommandsData)args).getCommands();
                if (commands != null && !commands.isEmpty()) {
                    ((Span)span.appendToName(((CommandData)commands.get(0)).getCommand().getName())).appendToName("... [bulk]");
                }
            } else if (args instanceof CommandData) {
                span.appendToName(((CommandData)args).getCommand().getName());
            }
            Channel channel = connection.getChannel();
            InetSocketAddress remoteAddress = (InetSocketAddress)channel.remoteAddress();
            span.getContext().getDestination().withAddress(remoteAddress.getAddress().getHostAddress()).withPort(remoteAddress.getPort());
        }
    }

    @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
    private static void afterSend(@Nullable @Advice.Local(value="span") Span span, @Nullable @Advice.Thrown Throwable thrown) {
        if (span != null) {
            ((Span)((Span)span.captureException(thrown)).deactivate()).end();
        }
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("org.redisson.client.RedisConnection").and(ElementMatchers.declaresMethod(ElementMatchers.named("getChannel")));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("send");
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Arrays.asList("redis", "redisson");
    }
}

