/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.report.serialize;

import co.elastic.apm.agent.metrics.DoubleSupplier;
import co.elastic.apm.agent.metrics.Labels;
import co.elastic.apm.agent.metrics.MetricSet;
import co.elastic.apm.agent.metrics.Timer;
import co.elastic.apm.agent.report.serialize.DslJsonSerializer;
import co.elastic.apm.agent.shaded.dslplatform.json.JsonWriter;
import co.elastic.apm.agent.shaded.dslplatform.json.NumberConverter;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class MetricRegistrySerializer {
    private static final byte NEW_LINE = 10;

    public static void serialize(Map<? extends Labels, MetricSet> metricSets, StringBuilder replaceBuilder, JsonWriter jw) {
        long timestamp = System.currentTimeMillis() * 1000L;
        for (MetricSet metricSet : metricSets.values()) {
            if (!metricSet.hasContent()) continue;
            MetricRegistrySerializer.serializeMetricSet(metricSet, timestamp, replaceBuilder, jw);
            metricSet.onAfterReport();
            jw.writeByte((byte)10);
        }
    }

    static void serializeMetricSet(MetricSet metricSet, long epochMicros, StringBuilder replaceBuilder, JsonWriter jw) {
        jw.writeByte((byte)123);
        DslJsonSerializer.writeFieldName("metricset", jw);
        jw.writeByte((byte)123);
        DslJsonSerializer.writeFieldName("timestamp", jw);
        NumberConverter.serialize(epochMicros, jw);
        jw.writeByte((byte)44);
        DslJsonSerializer.serializeLabels(metricSet.getLabels(), replaceBuilder, jw);
        DslJsonSerializer.writeFieldName("samples", jw);
        jw.writeByte((byte)123);
        boolean hasSamples = MetricRegistrySerializer.serializeGauges(metricSet.getGauges(), jw);
        hasSamples |= MetricRegistrySerializer.serializeTimers(metricSet.getTimers(), hasSamples, jw);
        MetricRegistrySerializer.serializeCounters(metricSet.getCounters(), hasSamples, jw);
        jw.writeByte((byte)125);
        jw.writeByte((byte)125);
        jw.writeByte((byte)125);
    }

    private static boolean serializeGauges(Map<String, DoubleSupplier> gauges, JsonWriter jw) {
        int size = gauges.size();
        if (size > 0) {
            Map.Entry<String, DoubleSupplier> kv;
            Iterator<Map.Entry<String, DoubleSupplier>> iterator = gauges.entrySet().iterator();
            double value = Double.NaN;
            while (iterator.hasNext() && !MetricRegistrySerializer.isValid(value)) {
                kv = iterator.next();
                value = kv.getValue().get();
                if (!MetricRegistrySerializer.isValid(value)) continue;
                MetricRegistrySerializer.serializeValue(kv.getKey(), value, jw);
            }
            while (iterator.hasNext()) {
                kv = iterator.next();
                value = kv.getValue().get();
                if (!MetricRegistrySerializer.isValid(value)) continue;
                jw.writeByte((byte)44);
                MetricRegistrySerializer.serializeValue(kv.getKey(), value, jw);
            }
            return true;
        }
        return false;
    }

    private static boolean serializeTimers(Map<String, Timer> timers, boolean hasSamples, JsonWriter jw) {
        int size = timers.size();
        if (size > 0) {
            Map.Entry<String, Timer> kv;
            Iterator<Map.Entry<String, Timer>> iterator = timers.entrySet().iterator();
            Timer value = null;
            while (iterator.hasNext() && value == null) {
                kv = iterator.next();
                if (!kv.getValue().hasContent()) continue;
                value = kv.getValue();
                if (hasSamples) {
                    jw.writeByte((byte)44);
                }
                hasSamples = true;
                MetricRegistrySerializer.serializeTimer(kv.getKey(), value, jw);
            }
            while (iterator.hasNext()) {
                kv = iterator.next();
                value = kv.getValue();
                if (!value.hasContent()) continue;
                jw.writeByte((byte)44);
                MetricRegistrySerializer.serializeTimer(kv.getKey(), value, jw);
            }
        }
        return hasSamples;
    }

    private static void serializeCounters(Map<String, AtomicLong> counters, boolean hasSamples, JsonWriter jw) {
        int size = counters.size();
        if (size > 0) {
            Map.Entry<String, AtomicLong> kv;
            Iterator<Map.Entry<String, AtomicLong>> iterator = counters.entrySet().iterator();
            AtomicLong value = null;
            while (iterator.hasNext() && value == null) {
                kv = iterator.next();
                if (kv.getValue().get() <= 0L) continue;
                value = kv.getValue();
                if (hasSamples) {
                    jw.writeByte((byte)44);
                }
                MetricRegistrySerializer.serializeCounter(kv.getKey(), value, jw);
            }
            while (iterator.hasNext()) {
                kv = iterator.next();
                value = kv.getValue();
                if (kv.getValue().get() <= 0L) continue;
                jw.writeByte((byte)44);
                MetricRegistrySerializer.serializeCounter(kv.getKey(), value, jw);
            }
        }
    }

    private static void serializeCounter(String key, AtomicLong value, JsonWriter jw) {
        MetricRegistrySerializer.serializeValueStart(key, "", jw);
        NumberConverter.serialize(value.get(), jw);
        jw.writeByte((byte)125);
        value.set(0L);
    }

    private static boolean isValid(double value) {
        return !Double.isInfinite(value) && !Double.isNaN(value);
    }

    private static void serializeTimer(String key, Timer timer, JsonWriter jw) {
        MetricRegistrySerializer.serializeValue(key, ".count", timer.getCount(), jw);
        jw.writeByte((byte)44);
        MetricRegistrySerializer.serializeValue(key, ".sum.us", timer.getTotalTimeUs(), jw);
        timer.resetState();
    }

    private static void serializeValue(String key, double value, JsonWriter jw) {
        MetricRegistrySerializer.serializeValue(key, "", value, jw);
    }

    private static void serializeValue(String key, String suffix, double value, JsonWriter jw) {
        MetricRegistrySerializer.serializeValueStart(key, suffix, jw);
        NumberConverter.serialize(value, jw);
        jw.writeByte((byte)125);
    }

    private static void serializeValue(String key, String suffix, long value, JsonWriter jw) {
        MetricRegistrySerializer.serializeValueStart(key, suffix, jw);
        NumberConverter.serialize(value, jw);
        jw.writeByte((byte)125);
    }

    private static void serializeValueStart(String key, String suffix, JsonWriter jw) {
        jw.writeByte((byte)34);
        jw.writeAscii(key);
        jw.writeAscii(suffix);
        jw.writeByte((byte)34);
        jw.writeByte((byte)58);
        jw.writeByte((byte)123);
        jw.writeByte((byte)34);
        jw.writeAscii("value");
        jw.writeByte((byte)34);
        jw.writeByte((byte)58);
    }
}

