/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.servlet;

import co.elastic.apm.agent.bci.ElasticApmInstrumentation;
import co.elastic.apm.agent.bci.HelperClassManager;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.servlet.AbstractServletInstrumentation;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.NamedElement;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nullable;
import javax.servlet.AsyncContext;

public abstract class AsyncInstrumentation
extends AbstractServletInstrumentation {
    private static final String SERVLET_API_ASYNC_GROUP_NAME = "servlet-api-async";
    @Nullable
    public static HelperClassManager<AsyncContextAdviceHelper<AsyncContext>> asyncHelperManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsyncInstrumentation(ElasticApmTracer tracer) {
        Class<AsyncInstrumentation> clazz = AsyncInstrumentation.class;
        synchronized (AsyncInstrumentation.class) {
            asyncHelperManager = HelperClassManager.ForSingleClassLoader.of(tracer, "co.elastic.apm.agent.servlet.helper.AsyncContextAdviceHelperImpl", "co.elastic.apm.agent.servlet.helper.AsyncContextAdviceHelperImpl$ApmAsyncListenerAllocator", "co.elastic.apm.agent.servlet.helper.ApmAsyncListener");
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Arrays.asList("servlet-api", SERVLET_API_ASYNC_GROUP_NAME);
    }

    public static class AsyncContextInstrumentation
    extends AsyncInstrumentation {
        public AsyncContextInstrumentation(ElasticApmTracer tracer) {
            super(tracer);
        }

        @Override
        public ElementMatcher<? super NamedElement> getTypeMatcherPreFilter() {
            return ElementMatchers.nameContains("AsyncContext");
        }

        @Override
        public ElementMatcher<? super TypeDescription> getTypeMatcher() {
            return ElementMatchers.not(ElementMatchers.isInterface()).and(ElementMatchers.hasSuperType(ElementMatchers.named("javax.servlet.AsyncContext")));
        }

        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.isPublic().and(ElementMatchers.named("start")).and(ElementMatchers.takesArguments(Runnable.class));
        }

        @Override
        public Class<?> getAdviceClass() {
            return AsyncContextStartAdvice.class;
        }

        public static class AsyncContextStartAdvice {
            @Advice.OnMethodEnter(suppress=Throwable.class)
            private static void onEnterAsyncContextStart(@Advice.Argument(value=0, readOnly=false) @Nullable Runnable runnable) {
                Transaction transaction;
                if (ElasticApmInstrumentation.tracer != null && runnable != null && ElasticApmInstrumentation.tracer.isWrappingAllowedOnThread() && (transaction = ElasticApmInstrumentation.tracer.currentTransaction()) != null) {
                    runnable = transaction.withActive(runnable);
                    ElasticApmInstrumentation.tracer.avoidWrappingOnThread();
                }
            }

            @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Exception.class)
            private static void onExitAsyncContextStart() {
                if (ElasticApmInstrumentation.tracer != null) {
                    ElasticApmInstrumentation.tracer.allowWrappingOnThread();
                }
            }
        }
    }

    public static class StartAsyncInstrumentation
    extends AsyncInstrumentation {
        public StartAsyncInstrumentation(ElasticApmTracer tracer) {
            super(tracer);
        }

        @Override
        public ElementMatcher<? super NamedElement> getTypeMatcherPreFilter() {
            return ElementMatchers.nameContains("Request");
        }

        @Override
        public ElementMatcher<? super TypeDescription> getTypeMatcher() {
            return ElementMatchers.not(ElementMatchers.isInterface()).and(ElementMatchers.hasSuperType(ElementMatchers.named("javax.servlet.ServletRequest")));
        }

        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.isPublic().and(ElementMatchers.named("startAsync")).and(ElementMatchers.returns(ElementMatchers.named("javax.servlet.AsyncContext"))).and(ElementMatchers.takesArguments(0).or(ElementMatchers.takesArgument(0, ElementMatchers.named("javax.servlet.ServletRequest")).and(ElementMatchers.takesArgument(1, ElementMatchers.named("javax.servlet.ServletResponse")))));
        }

        @Override
        public Class<?> getAdviceClass() {
            return StartAsyncAdvice.class;
        }

        public static class StartAsyncAdvice {
            @Advice.OnMethodExit(suppress=Throwable.class)
            private static void onExitStartAsync(@Advice.Return AsyncContext asyncContext) {
                AsyncContextAdviceHelper<AsyncContext> helperImpl;
                if (ElasticApmInstrumentation.tracer != null && asyncHelperManager != null && (helperImpl = asyncHelperManager.getForClassLoaderOfClass(AsyncContext.class)) != null) {
                    helperImpl.onExitStartAsync(asyncContext);
                }
            }
        }
    }

    public static interface AsyncContextAdviceHelper<T> {
        public void onExitStartAsync(T var1);
    }
}

