/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.servlet;

import co.elastic.apm.agent.bci.HelperClassManager;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.servlet.AbstractServletInstrumentation;
import co.elastic.apm.agent.servlet.ServletApiAdvice;
import co.elastic.apm.agent.shaded.bytebuddy.description.NamedElement;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;

public class ServletInstrumentation
extends AbstractServletInstrumentation {
    static final String SERVLET_API = "servlet-api";
    @Nullable
    public static HelperClassManager<ServletTransactionCreationHelper<HttpServletRequest>> servletTransactionCreationHelperManager;

    public ServletInstrumentation(ElasticApmTracer tracer) {
        ServletApiAdvice.init(tracer);
        servletTransactionCreationHelperManager = HelperClassManager.ForSingleClassLoader.of(tracer, "co.elastic.apm.agent.servlet.helper.ServletTransactionCreationHelperImpl", "co.elastic.apm.agent.servlet.helper.ServletRequestHeaderGetter");
    }

    @Override
    public ElementMatcher<? super NamedElement> getTypeMatcherPreFilter() {
        return ElementMatchers.nameContains("Servlet").or(ElementMatchers.nameContainsIgnoreCase("jsp"));
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.not(ElementMatchers.isInterface()).and(ElementMatchers.hasSuperType(ElementMatchers.named("javax.servlet.Servlet")));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("service").and(ElementMatchers.takesArgument(0, ElementMatchers.named("javax.servlet.ServletRequest"))).and(ElementMatchers.takesArgument(1, ElementMatchers.named("javax.servlet.ServletResponse")));
    }

    @Override
    public Class<?> getAdviceClass() {
        return ServletApiAdvice.class;
    }

    public static interface ServletTransactionCreationHelper<R> {
        @Nullable
        public Transaction createAndActivateTransaction(R var1);
    }
}

