/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.shaded.bytebuddy.utility.visitor;

import co.elastic.apm.agent.shaded.bytebuddy.jar.asm.AnnotationVisitor;
import co.elastic.apm.agent.shaded.bytebuddy.jar.asm.Attribute;
import co.elastic.apm.agent.shaded.bytebuddy.jar.asm.ClassVisitor;
import co.elastic.apm.agent.shaded.bytebuddy.jar.asm.FieldVisitor;
import co.elastic.apm.agent.shaded.bytebuddy.jar.asm.MethodVisitor;
import co.elastic.apm.agent.shaded.bytebuddy.jar.asm.TypePath;

public abstract class MetadataAwareClassVisitor
extends ClassVisitor {
    private boolean triggerNestHost = true;
    private boolean triggerOuterClass = true;
    private boolean triggerAttributes = true;

    protected MetadataAwareClassVisitor(int api, ClassVisitor classVisitor) {
        super(api, classVisitor);
    }

    protected abstract void onNestHost();

    protected abstract void onOuterType();

    protected abstract void onAfterAttributes();

    private void considerTriggerNestHost() {
        if (this.triggerNestHost) {
            this.triggerNestHost = false;
            this.onNestHost();
        }
    }

    private void considerTriggerOuterClass() {
        if (this.triggerOuterClass) {
            this.triggerOuterClass = false;
            this.onOuterType();
        }
    }

    private void considerTriggerAfterAttributes() {
        if (this.triggerAttributes) {
            this.triggerAttributes = false;
            this.onAfterAttributes();
        }
    }

    public final void visitNestHost(String nestHost) {
        this.triggerNestHost = false;
        this.onVisitNestHost(nestHost);
    }

    protected void onVisitNestHost(String nestHost) {
        super.visitNestHost(nestHost);
    }

    public final void visitOuterClass(String owner, String name, String descriptor) {
        this.considerTriggerNestHost();
        this.triggerOuterClass = false;
        this.onVisitOuterClass(owner, name, descriptor);
    }

    protected void onVisitOuterClass(String owner, String name, String descriptor) {
        super.visitOuterClass(owner, name, descriptor);
    }

    public final AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        this.considerTriggerNestHost();
        this.considerTriggerOuterClass();
        return this.onVisitAnnotation(descriptor, visible);
    }

    protected AnnotationVisitor onVisitAnnotation(String descriptor, boolean visible) {
        return super.visitAnnotation(descriptor, visible);
    }

    public final AnnotationVisitor visitTypeAnnotation(int typeReference, TypePath typePath, String descriptor, boolean visible) {
        this.considerTriggerNestHost();
        this.considerTriggerOuterClass();
        return this.onVisitTypeAnnotation(typeReference, typePath, descriptor, visible);
    }

    protected AnnotationVisitor onVisitTypeAnnotation(int typeReference, TypePath typePath, String descriptor, boolean visible) {
        return super.visitTypeAnnotation(typeReference, typePath, descriptor, visible);
    }

    public final void visitAttribute(Attribute attribute) {
        this.considerTriggerNestHost();
        this.considerTriggerOuterClass();
        this.onVisitAttribute(attribute);
    }

    protected void onVisitAttribute(Attribute attribute) {
        super.visitAttribute(attribute);
    }

    public final void visitNestMember(String nestMember) {
        this.considerTriggerNestHost();
        this.considerTriggerOuterClass();
        this.considerTriggerAfterAttributes();
        this.onVisitNestMember(nestMember);
    }

    protected void onVisitNestMember(String nestMember) {
        super.visitNestMember(nestMember);
    }

    public final void visitInnerClass(String name, String outerName, String innerName, int modifiers) {
        this.considerTriggerNestHost();
        this.considerTriggerOuterClass();
        this.considerTriggerAfterAttributes();
        this.onVisitInnerClass(name, outerName, innerName, modifiers);
    }

    protected void onVisitInnerClass(String name, String outerName, String innerName, int modifiers) {
        super.visitInnerClass(name, outerName, innerName, modifiers);
    }

    public final FieldVisitor visitField(int modifiers, String internalName, String descriptor, String signature, Object defaultValue) {
        this.considerTriggerNestHost();
        this.considerTriggerOuterClass();
        this.considerTriggerAfterAttributes();
        return this.onVisitField(modifiers, internalName, descriptor, signature, defaultValue);
    }

    protected FieldVisitor onVisitField(int modifiers, String internalName, String descriptor, String signature, Object defaultValue) {
        return super.visitField(modifiers, internalName, descriptor, signature, defaultValue);
    }

    public final MethodVisitor visitMethod(int modifiers, String internalName, String descriptor, String signature, String[] exception) {
        this.considerTriggerNestHost();
        this.considerTriggerOuterClass();
        this.considerTriggerAfterAttributes();
        return this.onVisitMethod(modifiers, internalName, descriptor, signature, exception);
    }

    protected MethodVisitor onVisitMethod(int modifiers, String internalName, String descriptor, String signature, String[] exception) {
        return super.visitMethod(modifiers, internalName, descriptor, signature, exception);
    }

    public final void visitEnd() {
        this.considerTriggerNestHost();
        this.considerTriggerOuterClass();
        this.considerTriggerAfterAttributes();
        this.onVisitEnd();
    }

    protected void onVisitEnd() {
        super.visitEnd();
    }
}

