/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.shaded.stagemonitor.configuration.source;

import co.elastic.apm.agent.shaded.stagemonitor.configuration.source.AbstractConfigurationSource;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class SimpleSource
extends AbstractConfigurationSource {
    public static final String NAME = "Transient Configuration Source";
    private final ConcurrentMap<String, String> config = new ConcurrentHashMap<String, String>();
    private final String name;

    public SimpleSource() {
        this(NAME);
    }

    public SimpleSource(String name) {
        this.name = name;
    }

    public static SimpleSource forTest(String key, String value) {
        SimpleSource simpleConfig = new SimpleSource("Test Configuration Source");
        simpleConfig.add(key, value);
        return simpleConfig;
    }

    @Override
    public String getValue(String key) {
        return (String)this.config.get(key);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isSavingPossible() {
        return true;
    }

    @Override
    public void save(String key, String value) throws IOException {
        this.config.put(key, value);
    }

    public SimpleSource add(String key, String value) {
        this.config.put(key, value);
        return this;
    }
}

