/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.spring.scheduled;

import co.elastic.apm.agent.bci.ElasticApmInstrumentation;
import co.elastic.apm.agent.bci.bytebuddy.CustomElementMatchers;
import co.elastic.apm.agent.bci.bytebuddy.SimpleMethodSignatureOffsetMappingFactory;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.stacktrace.StacktraceConfiguration;
import co.elastic.apm.agent.impl.transaction.TraceContextHolder;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import co.elastic.apm.agent.shaded.slf4j.Logger;
import co.elastic.apm.agent.shaded.slf4j.LoggerFactory;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nullable;

public class ScheduledTransactionNameInstrumentation
extends ElasticApmInstrumentation {
    public static final Logger logger = LoggerFactory.getLogger(ScheduledTransactionNameInstrumentation.class);
    private final Collection<String> applicationPackages;

    public ScheduledTransactionNameInstrumentation(ElasticApmTracer tracer) {
        this.applicationPackages = tracer.getConfig(StacktraceConfiguration.class).getApplicationPackages();
    }

    @Advice.OnMethodEnter(suppress=Throwable.class)
    private static void setTransactionName(@SimpleMethodSignatureOffsetMappingFactory.SimpleMethodSignature String signature, @Advice.Origin Class<?> clazz, @Advice.Local(value="transaction") Transaction transaction) {
        if (tracer != null) {
            TraceContextHolder<?> active = tracer.getActive();
            if (active == null) {
                transaction = tracer.startRootTransaction(clazz.getClassLoader());
                if (transaction != null) {
                    ((Transaction)transaction.withName(signature)).withType("scheduled").activate();
                }
            } else {
                logger.debug("Not creating transaction for method {} because there is already a transaction running ({})", (Object)signature, (Object)active);
            }
        }
    }

    @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class)
    public static void onMethodExit(@Nullable @Advice.Local(value="transaction") Transaction transaction, @Advice.Thrown Throwable t) {
        if (transaction != null) {
            ((Transaction)((Transaction)transaction.captureException(t)).deactivate()).end();
        }
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return CustomElementMatchers.isInAnyPackage(this.applicationPackages, ElementMatchers.none()).and(ElementMatchers.declaresMethod(this.getMethodMatcher()));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.isAnnotatedWith(ElementMatchers.named("org.springframework.scheduling.annotation.Scheduled").or(ElementMatchers.named("org.springframework.scheduling.annotation.Schedules")).or(ElementMatchers.named("javax.ejb.Schedule")).or(ElementMatchers.named("javax.ejb.Schedules")));
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Arrays.asList("concurrent", "scheduled");
    }
}

