/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.spring.webmvc;

import co.elastic.apm.agent.bci.ElasticApmInstrumentation;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import java.util.Arrays;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;

public class ExceptionHandlerInstrumentation
extends ElasticApmInstrumentation {
    @Override
    public Class<?> getAdviceClass() {
        return ExceptionHandlerAdviceService.class;
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("org.springframework.web.servlet.DispatcherServlet");
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("processHandlerException").and(ElementMatchers.takesArgument(0, ElementMatchers.named("javax.servlet.http.HttpServletRequest"))).and(ElementMatchers.takesArgument(1, ElementMatchers.named("javax.servlet.http.HttpServletResponse"))).and(ElementMatchers.takesArgument(2, ElementMatchers.named("java.lang.Object"))).and(ElementMatchers.takesArgument(3, ElementMatchers.named("java.lang.Exception"))).and(ElementMatchers.returns(ElementMatchers.named("org.springframework.web.servlet.ModelAndView")));
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Arrays.asList("exception-handler");
    }

    public static class ExceptionHandlerAdviceService {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static void captureException(@Advice.Argument(value=0) HttpServletRequest request, @Advice.Argument(value=3) Exception e) {
            if (request != null && e != null) {
                request.setAttribute("co.elastic.apm.exception", (Object)e);
            }
        }
    }
}

