/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.Set;
import javax.annotation.Nullable;

public class DependencyInjectingServiceLoader<T> {
    private final Class<T> clazz;
    private final Object[] constructorArguments;
    private final Class<?>[] constructorTypes;
    private final List<T> instances = new ArrayList<T>();
    @Nullable
    private final ClassLoader classLoader;

    private DependencyInjectingServiceLoader(Class<T> clazz, Object ... constructorArguments) {
        this.clazz = clazz;
        this.constructorArguments = constructorArguments;
        this.classLoader = clazz.getClassLoader();
        ArrayList types = new ArrayList(constructorArguments.length);
        for (Object constructorArgument : constructorArguments) {
            types.add(constructorArgument.getClass());
        }
        this.constructorTypes = types.toArray(new Class[0]);
        try {
            Enumeration<URL> resources = this.getServiceDescriptors(clazz);
            Set<String> implementations = this.getImplementations(resources);
            this.instantiate(implementations);
        }
        catch (IOException e) {
            throw new ServiceConfigurationError(e.getMessage(), e);
        }
    }

    private Enumeration<URL> getServiceDescriptors(Class<T> clazz) throws IOException {
        if (this.classLoader != null) {
            return this.classLoader.getResources("META-INF/services/" + clazz.getName());
        }
        return ClassLoader.getSystemResources("META-INF/services/" + clazz.getName());
    }

    public static <T> List<T> load(Class<T> clazz, Object ... constructorArguments) {
        return new DependencyInjectingServiceLoader<T>(clazz, (Object[])constructorArguments).instances;
    }

    private static boolean isComment(String serviceImplementationClassName) {
        return serviceImplementationClassName.startsWith("#");
    }

    private Set<String> getImplementations(Enumeration<URL> resources) throws IOException {
        LinkedHashSet<String> implementations = new LinkedHashSet<String>();
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            InputStream inputStream = url.openStream();
            Throwable throwable = null;
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
                while (reader.ready()) {
                    String line = reader.readLine().trim();
                    if (DependencyInjectingServiceLoader.isComment(line) || line.isEmpty()) continue;
                    implementations.add(line);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (inputStream == null) continue;
                if (throwable != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                inputStream.close();
            }
        }
        return implementations;
    }

    private void instantiate(Set<String> implementations) {
        for (String implementation : implementations) {
            this.instances.add(this.instantiate(implementation));
        }
    }

    private T instantiate(String implementation) {
        try {
            Class<?> implementationClass = Class.forName(implementation, true, this.classLoader);
            DependencyInjectingServiceLoader.checkClassModifiers(implementationClass);
            Constructor<?> constructor = this.getMatchingConstructor(implementationClass);
            if (constructor != null) {
                DependencyInjectingServiceLoader.checkConstructorModifiers(constructor);
                return this.clazz.cast(constructor.newInstance(this.constructorArguments));
            }
            constructor = implementationClass.getConstructor(new Class[0]);
            DependencyInjectingServiceLoader.checkConstructorModifiers(constructor);
            return this.clazz.cast(constructor.newInstance(new Object[0]));
        }
        catch (InstantiationException e) {
            String msg = String.format("unable to instantiate '%s', please check descriptor in META-INF", implementation);
            throw new ServiceConfigurationError(msg, e);
        }
        catch (Exception e) {
            throw new ServiceConfigurationError(e.getMessage(), e);
        }
    }

    private static void checkConstructorModifiers(Constructor<?> constructor) {
        if (!Modifier.isPublic(constructor.getModifiers())) {
            throw new ServiceConfigurationError("constructor is not public : " + constructor);
        }
    }

    private static void checkClassModifiers(Class<?> clazz) {
        boolean isAbstract = Modifier.isAbstract(clazz.getModifiers());
        boolean isPublic = Modifier.isPublic(clazz.getModifiers());
        if (isAbstract || !isPublic) {
            throw new ServiceConfigurationError(String.format("unable to instantiate '%s' because it's either abstract or not public", clazz));
        }
    }

    @Nullable
    private Constructor<?> getMatchingConstructor(Class<?> implementationClass) {
        for (Constructor<?> constructor : implementationClass.getConstructors()) {
            if (!this.isAllAssignableFrom(constructor.getParameterTypes(), this.constructorTypes)) continue;
            return constructor;
        }
        return null;
    }

    private boolean isAllAssignableFrom(Class<?>[] types, Class<?>[] otherTypes) {
        if (types.length != otherTypes.length) {
            return false;
        }
        for (int i = 0; i < types.length; ++i) {
            if (types[i].isAssignableFrom(otherTypes[i])) continue;
            return false;
        }
        return true;
    }
}

