/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.util;

import co.elastic.apm.agent.shaded.dslplatform.json.JsonWriter;

public class HexUtils {
    private static final char[] hexArray = "0123456789abcdef".toCharArray();

    private HexUtils() {
    }

    public static String bytesToHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        HexUtils.writeBytesAsHex(bytes, sb);
        return sb.toString();
    }

    public static void writeBytesAsHex(byte[] bytes, JsonWriter jw) {
        for (int i = 0; i < bytes.length; ++i) {
            int v = bytes[i] & 0xFF;
            jw.writeByte((byte)hexArray[v >>> 4]);
            jw.writeByte((byte)hexArray[v & 0xF]);
        }
    }

    public static void writeBytesAsHex(byte[] bytes, StringBuilder sb) {
        HexUtils.writeBytesAsHex(bytes, 0, bytes.length, sb);
    }

    public static void writeBytesAsHex(byte[] bytes, int offset, int length, StringBuilder sb) {
        for (int i = offset; i < offset + length; ++i) {
            HexUtils.writeByteAsHex(bytes[i], sb);
        }
    }

    public static void writeByteAsHex(byte b, StringBuilder sb) {
        int v = b & 0xFF;
        sb.append(hexArray[v >>> 4]);
        sb.append(hexArray[v & 0xF]);
    }

    public static byte getNextByte(String hexEncodedString, int offset) {
        int hi = HexUtils.hexCharToBinary(hexEncodedString.charAt(offset));
        int lo = HexUtils.hexCharToBinary(hexEncodedString.charAt(offset + 1));
        if (hi == -1 || lo == -1) {
            throw new IllegalArgumentException("Not a hex encoded string: " + hexEncodedString + " at offset " + offset);
        }
        return (byte)((hi << 4) + lo);
    }

    private static int hexCharToBinary(char ch) {
        if ('0' <= ch && ch <= '9') {
            return ch - 48;
        }
        if ('A' <= ch && ch <= 'F') {
            return ch - 65 + 10;
        }
        if ('a' <= ch && ch <= 'f') {
            return ch - 97 + 10;
        }
        return -1;
    }

    public static void nextBytes(String hexEncodedString, int offset, byte[] bytes) {
        int charsToRead = bytes.length * 2;
        if (hexEncodedString.length() < offset + charsToRead) {
            throw new IllegalArgumentException(String.format("Can't read %d bytes from string %s with offset %d", bytes.length, hexEncodedString, offset));
        }
        for (int i = 0; i < charsToRead; i += 2) {
            bytes[i / 2] = HexUtils.getNextByte(hexEncodedString, offset + i);
        }
    }

    public static void decode(String hexEncodedString, int srcOffset, int srcLength, byte[] bytes, int destOffset) {
        if (hexEncodedString.length() < srcOffset + srcLength) {
            throw new IllegalArgumentException(String.format("Can't read %d chars from string %s with offset %d", srcLength, hexEncodedString, srcOffset));
        }
        for (int i = 0; i < srcLength; i += 2) {
            bytes[destOffset + i / 2] = HexUtils.getNextByte(hexEncodedString, srcOffset + i);
        }
    }
}

