/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.util;

import co.elastic.apm.agent.objectpool.Recyclable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;

public class NoRandomAccessMap<K, V>
implements Recyclable,
Iterable<Entry<K, V>> {
    private List<K> keys = new ArrayList<K>();
    private List<V> values = new ArrayList<V>();
    private NoGarbageIterator iterator = new NoGarbageIterator();

    public void add(K key, @Nullable V value) throws NullPointerException {
        if (key == null) {
            throw new NullPointerException("This map doesn't support null keys");
        }
        this.keys.add(key);
        this.values.add(value);
    }

    public int size() {
        return this.keys.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public void resetState() {
        this.keys.clear();
        this.values.clear();
        this.iterator.reset();
    }

    @Override
    public Iterator<Entry<K, V>> iterator() {
        this.iterator.reset();
        return this.iterator;
    }

    public void copyFrom(NoRandomAccessMap<K, V> other) {
        this.resetState();
        for (Entry<K, V> entry : other) {
            this.add(entry.getKey(), entry.getValue());
        }
    }

    private class NoGarbageIterator
    implements Iterator<Entry<K, V>> {
        int index = 0;
        final EntryImpl entry = new EntryImpl();

        private NoGarbageIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < NoRandomAccessMap.this.keys.size();
        }

        @Override
        public Entry<K, V> next() {
            this.entry.key = NoRandomAccessMap.this.keys.get(this.index);
            this.entry.value = NoRandomAccessMap.this.values.get(this.index);
            ++this.index;
            return this.entry;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        void reset() {
            this.index = 0;
            this.entry.reset();
        }
    }

    private class EntryImpl
    implements Entry<K, V> {
        @Nullable
        K key;
        @Nullable
        V value;

        private EntryImpl() {
        }

        @Override
        public K getKey() {
            if (this.key == null) {
                throw new IllegalStateException("Key shouldn't be null. Make sure you don't read and write to this map concurrently");
            }
            return this.key;
        }

        @Override
        @Nullable
        public V getValue() {
            return this.value;
        }

        void reset() {
            this.key = null;
            this.value = null;
        }
    }

    public static interface Entry<K, V> {
        public K getKey();

        @Nullable
        public V getValue();
    }
}

