/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.util;

public class Version
implements Comparable<Version> {
    private final int[] numbers;

    public static Version of(String version) {
        return new Version(version);
    }

    private Version(String version) {
        String[] parts = version.split("\\-")[0].split("\\.");
        this.numbers = new int[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            this.numbers[i] = Integer.valueOf(parts[i]);
        }
    }

    @Override
    public int compareTo(Version another) {
        int maxLength = Math.max(this.numbers.length, another.numbers.length);
        for (int i = 0; i < maxLength; ++i) {
            int right;
            int left = i < this.numbers.length ? this.numbers[i] : 0;
            int n = right = i < another.numbers.length ? another.numbers[i] : 0;
            if (left == right) continue;
            return left < right ? -1 : 1;
        }
        return 0;
    }
}

