/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.bci.bytebuddy;

import co.elastic.apm.agent.shaded.bytebuddy.ClassFileVersion;
import co.elastic.apm.agent.shaded.bytebuddy.asm.AsmVisitorWrapper;
import co.elastic.apm.agent.shaded.bytebuddy.description.field.FieldDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.field.FieldList;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodList;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.agent.shaded.bytebuddy.implementation.Implementation;
import co.elastic.apm.agent.shaded.bytebuddy.jar.asm.ClassVisitor;
import co.elastic.apm.agent.shaded.bytebuddy.pool.TypePool;
import co.elastic.apm.agent.shaded.bytebuddy.utility.OpenedClassReader;

public enum MinimumClassFileVersionValidator implements AsmVisitorWrapper
{
    INSTANCE;

    private static final ClassFileVersion MINIMUM_CLASS_FILE_VERSION;

    @Override
    public ClassVisitor wrap(TypeDescription instrumentedType, ClassVisitor classVisitor, Implementation.Context implementationContext, TypePool typePool, FieldList<FieldDescription.InDefinedShape> fields, MethodList<?> methods, int writerFlags, int readerFlags) {
        return new ClassVisitor(OpenedClassReader.ASM_API, classVisitor){

            @Override
            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                ClassFileVersion classFileVersion = ClassFileVersion.ofMinorMajor(version);
                if (!classFileVersion.isAtLeast(MINIMUM_CLASS_FILE_VERSION)) {
                    throw UnsupportedClassFileVersionException.INSTANCE;
                }
                super.visit(version, access, name, signature, superName, interfaces);
            }
        };
    }

    @Override
    public int mergeWriter(int flags) {
        return flags;
    }

    @Override
    public int mergeReader(int flags) {
        return flags;
    }

    static {
        MINIMUM_CLASS_FILE_VERSION = ClassFileVersion.JAVA_V5;
    }

    public static class UnsupportedClassFileVersionException
    extends RuntimeException {
        static final UnsupportedClassFileVersionException INSTANCE = new UnsupportedClassFileVersionException();

        private UnsupportedClassFileVersionException() {
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }
}

