/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.collections;

import java.util.Arrays;

public class LongList {
    private static final int DEFAULT_CAPACITY = 16;
    private long[] longs;
    private int size;

    public LongList() {
        this(16);
    }

    public LongList(int initialCapacity) {
        this.longs = new long[initialCapacity];
    }

    public static LongList of(long ... values) {
        LongList list = new LongList(values.length);
        for (long value : values) {
            list.add(value);
        }
        return list;
    }

    public void add(long l) {
        this.ensureCapacity(this.size + 1);
        this.longs[this.size++] = l;
    }

    public void addAll(LongList other) {
        this.ensureCapacity(this.size + other.size);
        System.arraycopy(other.longs, 0, this.longs, this.size, other.size);
        this.size += other.size;
    }

    private void ensureCapacity(int size) {
        if (this.longs.length < size) {
            this.longs = Arrays.copyOf(this.longs, this.longs.length * 2);
        }
    }

    public int getSize() {
        return this.size;
    }

    public long get(int i) {
        if (i >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.longs[i];
    }

    public boolean contains(long l) {
        for (int i = 0; i < this.size; ++i) {
            if (this.longs[i] != l) continue;
            return true;
        }
        return false;
    }

    public boolean remove(long l) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (this.longs[i] != l) continue;
            this.remove(i);
            return true;
        }
        return false;
    }

    public long remove(int i) {
        long previousValue = this.get(i);
        --this.size;
        if (this.size > i) {
            System.arraycopy(this.longs, i + 1, this.longs, i, this.size - i);
        }
        this.longs[this.size] = 0L;
        return previousValue;
    }

    public void clear() {
        Arrays.fill(this.longs, 0L);
        this.size = 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (int i = 0; i < this.size; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(this.longs[i]);
        }
        sb.append(']');
        return sb.toString();
    }

    public long[] toArray() {
        return Arrays.copyOfRange(this.longs, 0, this.size);
    }
}

