/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.configuration.converter;

import co.elastic.apm.agent.configuration.converter.TimeDuration;
import co.elastic.apm.agent.shaded.stagemonitor.configuration.ConfigurationOption;
import co.elastic.apm.agent.shaded.stagemonitor.configuration.converter.AbstractValueConverter;

public class TimeDurationValueConverter
extends AbstractValueConverter<TimeDuration> {
    private final String defaultDurationSuffix;

    private TimeDurationValueConverter(String defaultDurationSuffix) {
        this.defaultDurationSuffix = defaultDurationSuffix;
    }

    public static TimeDurationValueConverter withDefaultDuration(String defaultDurationSuffix) {
        return new TimeDurationValueConverter(defaultDurationSuffix);
    }

    public static ConfigurationOption.ConfigurationOptionBuilder<TimeDuration> durationOption(String defaultDuration) {
        return ConfigurationOption.builder(new TimeDurationValueConverter(defaultDuration), TimeDuration.class);
    }

    @Override
    public TimeDuration convert(String s) throws IllegalArgumentException {
        if (!(s.endsWith("ms") || s.endsWith("s") || s.endsWith("m"))) {
            s = s + this.defaultDurationSuffix;
        }
        return TimeDuration.of(s);
    }

    @Override
    public String toString(TimeDuration value) {
        return value.toString();
    }

    public String getDefaultDurationSuffix() {
        return this.defaultDurationSuffix;
    }
}

